
/* !!!! AUTOGENERATED FILE generated by math.rb !!!!! 
 *
 *  Copyright 2006 Øyvind Kolås <pippin@gimp.org>
 *
 * !!!! AUTOGENERATED FILE !!!!!
 *
 */
#if GEGL_CHANT_PROPERTIES
gegl_chant_double (value, -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, "global value used if aux doesn't contain data")
#else

#define GEGL_CHANT_NAME          gamma
#define GEGL_CHANT_SELF          "gamma.c"
#define GEGL_CHANT_DESCRIPTION   "Math operation gamma (c = powf (c, value))"
#define GEGL_CHANT_CATEGORIES    "compositors:math"

#define GEGL_CHANT_POINT_COMPOSER
#define GEGL_CHANT_PREPARE

#include "gegl-chant.h"

#include <math.h>

static void prepare (GeglOperation *operation,
                     gpointer       context_id)
{
  Babl *format = babl_format ("RGBA float");

  gegl_operation_set_format (operation, "input", format);
  gegl_operation_set_format (operation, "aux", babl_format ("RGB float"));
  gegl_operation_set_format (operation, "output", format);
}

static gboolean
process (GeglOperation *op,
          void          *in_buf,
          void          *aux_buf,
          void          *out_buf,
          glong          n_pixels)
{
  gint i;
  gfloat *in = in_buf;
  gfloat *out = out_buf;
  gfloat *aux = aux_buf;

  if (aux == NULL)
      {
          gfloat value = GEGL_CHANT_OPERATION (op)->value;
          for (i=0; i<n_pixels; i++)
            {
              int  j;
              gfloat c;
              for (j=0; j<3; j++)
                  {
                      c=in[j];
                      c = powf (c, value);
                      out[j]=c;
                  }
              out[3]=in[3];
              in += 4;
              out+= 4;
            }
      }
  else
      {
          for (i=0; i<n_pixels; i++)
            {
              int  j;
              gfloat c;
              gfloat value;
              for (j=0; j<3; j++)
                  {
                      c=in[j];
                      value=aux[j];
                      c = powf (c, value);
                      out[j]=c;
                  }
              out[3]=in[3];
              in += 4;
              aux += 3;
              out+= 4;
            }
      }
  
  return TRUE;
}
#endif
