static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"/tmp/test.raw\")                     \n"
"    description(_(\"Path of file to load.\"))                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE raw-load.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#ifdef HAVE_UNISTD_H                                                          \n"
"#include <unistd.h>                                                           \n"
"#endif                                                                        \n"
"#ifdef _WIN32                                                                 \n"
"#include <io.h>                                                               \n"
"#include <process.h>                                                          \n"
"#define popen(n,m) _popen(n,m)                                                \n"
"#define pclose(f) _pclose(f)                                                  \n"
"#endif                                                                        \n"
"#include <string.h>                                                           \n"
"#include <stdio.h>                                                            \n"
"#include <stdlib.h>                                                           \n"
"                                                                              \n"
"#define PIPE_MODE \"r\"                                                       \n"
"#define MAX_SAMPLE 65535                                                      \n"
"#define ERROR -1                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"load_buffer (GeglProperties *op_raw_load)                                     \n"
"{                                                                             \n"
"  if (!op_raw_load->user_data)                                                \n"
"    {                                                                         \n"
"      FILE  *pfp;                                                             \n"
"      gchar *command;                                                         \n"
"      gint   width, height, val_max;                                          \n"
"      gchar  newline;                                                         \n"
"                                                                              \n"
"      command = g_strdup_printf (\"dcraw -4 -c '%s'\\n\", op_raw_load->path); \n"
"      pfp = popen (command, PIPE_MODE);                                       \n"
"      g_free (command);                                                       \n"
"                                                                              \n"
"      if (fscanf (pfp, \"P6 %d %d %d %c\",                                    \n"
"         &width, &height, &val_max, &newline) != 4)                           \n"
"        {                                                                     \n"
"          pclose (pfp);                                                       \n"
"          g_warning (\"not able to aquire raw data\");                        \n"
"          return;                                                             \n"
"        }                                                                     \n"
"                                                                              \n"
"        {                                                                     \n"
"          GeglRectangle extent = { 0, 0, 0, 0 };                              \n"
"          extent.width = width;                                               \n"
"          extent.height = height;                                             \n"
"          op_raw_load->user_data = (gpointer) gegl_buffer_new (&extent,       \n"
"                                                   babl_format_new (          \n"
"                                                     babl_model (\"RGB\"),    \n"
"                                                     babl_type (\"u16\"),     \n"
"                                                     babl_component (\"G\"),  \n"
"                                                     babl_component (\"B\"),  \n"
"                                                     babl_component (\"R\"),  \n"
"                                                     NULL));                  \n"
"        }                                                                     \n"
"         {                                                                    \n"
"                                                                              \n"
"           guint16 *buf = g_new (guint16, width * height * 3);                \n"
"           fread (buf, 1, width * height * 3 * 2, pfp);                       \n"
"           gegl_buffer_set (GEGL_BUFFER (op_raw_load->user_data),             \n"
"                            NULL,                                             \n"
"                            0,                                                \n"
"                            babl_format_new (                                 \n"
"                                        babl_model (\"RGB\"),                 \n"
"                                        babl_type (\"u16\"),                  \n"
"                                        babl_component (\"G\"),               \n"
"                                        babl_component (\"B\"),               \n"
"                                        babl_component (\"R\"),               \n"
"                                        NULL),                                \n"
"                            buf,                                              \n"
"                            GEGL_AUTO_ROWSTRIDE                               \n"
"                           );                                                 \n"
"           g_free (buf);                                                      \n"
"         }                                                                    \n"
"       fclose (pfp);                                                          \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"                                                                              \n"
"  load_buffer (o);                                                            \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      result.width  = gegl_buffer_get_width  (GEGL_BUFFER (o->user_data));    \n"
"      result.height = gegl_buffer_get_height (GEGL_BUFFER (o->user_data));    \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation         *operation,                                    \n"
"         GeglOperationContext  *context,                                      \n"
"         const gchar           *output_pad,                                   \n"
"         const GeglRectangle   *result,                                       \n"
"         gint                   level)                                        \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglBuffer     *output;                                                     \n"
"                                                                              \n"
"  load_buffer (o);                                                            \n"
"  g_assert (o->user_data);                                                    \n"
"  g_assert (g_str_equal (output_pad, \"output\"));                            \n"
"                                                                              \n"
"  output = GEGL_BUFFER (o->user_data);                                        \n"
"  g_object_ref (output);                                                      \n"
"  gegl_operation_context_take_object (context, \"output\", G_OBJECT (output));\n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation *operation,                                  \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void finalize (GObject *object)                                        \n"
"{                                                                             \n"
"  GeglOperation *op = (void*) object;                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"  if (o->user_data)                                                           \n"
"    g_object_unref (o->user_data);                                            \n"
"  o->user_data = NULL;                                                        \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GObjectClass             *object_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  operation_class->process = process;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;;                    \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:raw-load\",                                       \n"
"    \"categories\" , \"hidden\",                                              \n"
"    \"description\",                                                          \n"
"          _(\"Raw image loader, wrapping dcraw with pipes.\"),                \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_extension_handler_register (\".raw\", \"gegl:raw-load\");              \n"
"  gegl_extension_handler_register (\".raf\", \"gegl:raw-load\");              \n"
"  gegl_extension_handler_register (\".nef\", \"gegl:raw-load\");              \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
