--TEST--
DBA CDB_MAKE handler test
--INI--
magic_quotes_runtime=1
--SKIPIF--
<?php 
	require_once('skipif.inc');
	if (!in_array('cdb_make', dba_handlers())) die('skip CDB_MAKE handler not available');
?>
--FILE--
<?php
	require_once('test.inc');
	$handler = 'cdb_make';
	echo "database handler: $handler\n";
	// print md5 checksum of test.cdb which is generated by cdb_make program
	var_dump(md5(implode('',file(dirname(__FILE__).'/test.cdb'))));
	if (($db_make=dba_open($db_file, "n", $handler))!==FALSE) {
		dba_insert("1", "1", $db_make);
		dba_insert("2", "2", $db_make);
		dba_insert("1", "3", $db_make);
		dba_insert("2", "1", $db_make);
		dba_insert("3", "3", $db_make);
		dba_insert("1", "2", $db_make);
		dba_insert("4", "4", $db_make);
//		dba_replace cdb_make doesn't know replace
		dba_close($db_make);
		// write md5 checksum of generated database file
		var_dump(md5(implode('',file($db_file))));
		// no need to test created database: this is done by dba_cdb_read.phpt
	} else {
		echo "Error creating database\n";
	}
?>
--EXPECT--
database handler: cdb_make
string(32) "723d19f39c1b15b3b455dd64323148d1"
string(32) "723d19f39c1b15b3b455dd64323148d1"