#include <stream.h>
#include "SimulationMultiplexor.h"
#include "Barrier.h"
#include "ControlTask.h"
#include "BarrierTest.h"

#define TRIALS 100
#define SAMPLES 10

extern Barrier TheBarrier;

ControlTask::ControlTask(int f, int t, int b)
{
    from = f;
    to = t;
    by = b;
    testers = 0;
}

void
ControlTask::main()
{
    for (int i = from; i <= to; i += by ) {
	TheBarrier.height(i+1);
	cout << "Build testers..\n";
	while( testers < i) {
	    ThisCpu -> add(new BarrierTest);
	    testers++;
	}

	cout << "Let everyone rendezvous\n";

	hold(1);
	stats.reset();
	//
	// start collecting sampls
	//
	for (int sample = 0; sample < SAMPLES; sample++ ) {
	    cout << ".." << sample << ".."; cout.flush();
	    start = simulatedClock();
	    for (int trial = 0; trial < TRIALS; trial++) {
		TheBarrier.rendezvous();
		hold(1);
	    }
	    double elapsed = simulatedClock() - start;
//	    cout << "Elapsed = " << elapsed << "\n";
	    stats += elapsed;
	}
	cout << "\n";
	cout << "For " << SAMPLES << " samples of " << TRIALS <<" trials\n";
	cout << "of " << i << " threads,\n";
	cout << "we get " << stats << "\n";
    }
}
