// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
//
// written by Dirk Grunwald (grunwald@cs.uiuc.edu)
//
#include "MultiCpuMuxExceptions.h"
#include "ReserveByException.h"
#include "CpuMultiplexor.h"
#include "HardwareContextP.h"
#include "MultiCpuMux.h"
#include "SpinBarrier.h"
#include "stream.h"
#include "Thread.h"

void
ExceptionRelocate::handleException()
{
    MultiCpuMux *cpu = (MultiCpuMux *) ThisCpu;
    //
    // Switch to another thread when we havenot gotten
    // rid of the current one.
    //
#ifndef NDEBUG
    if (cpu -> debug()) {
	CpuCerrLock.reserve();
	cerr << cpu -> name() << " reschedule exception to ";
	cerr << newCpu << "\n";
	CpuCerrLock.release();
    }
#endif /* NDEBUG */

    assert(cpu -> currentThread != 0);
    cpu -> addToAnother(newCpu, cpu -> currentThread );
    cpu -> currentThread = 0;
}

//
//	Used to add or remove CPUs from the current pool of CPUs
//

static SpinBarrier TwoCpuBarrier(2);

void
ExceptionEnrollDismissCpu::handleException()
{
    MultiCpuMux *cpu = (MultiCpuMux *) ThisCpu;
    if (enrollOrDismiss) {
	//
	// enroll
	//
	assert( cpu -> cpuId() == 0 );
	//
	//
	// Now fork the child. We need to insure that the new child
	// and the parent leave only after the data structures have been
	// created, otherwise barriers in subclasses may have problems.
	//
	int pid = fork();
	if ( pid == 0 ) {
	    cpu -> iYam = CpuMultiplexors;
	    //
	    // CpuMux::allocateEventStructures will set CpuMultiplexors
	    //
	    cpu -> allocateEventStructures(cpu -> iYam,
					       CpuMultiplexors+1 );
	    //
	    // cause child to schedule new process at stirItAround
	    //
	    cpu -> currentThread = 0;
	    cpu -> pid = getpid();
	}
	TwoCpuBarrier.rendezvous();
    }
    else {
	//
	// dismiss
	//
	assert( 0 );
    }
}
