// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#include "Thread.h"
#include "FifoScheduler.h"
#include "stream.h"
#include "assert.h"

FifoScheduler::FifoScheduler(int defaultLength, bool xdebug)
    : (xdebug), fifo(defaultLength)
{
    fifo.reSize(defaultLength);
}

void
FifoScheduler::add(Thread *t)
{
    fifo.add((AwesimePtr *) &t);
}

void
FifoScheduler::add(double , Thread *)
{
    assert2(FALSE, "[FifoScheduler] add(when, thread) not provided");
}

Thread *
FifoScheduler::remove()
{
    AwesimeFifoItem item;
    bool removed = fifo.remove(&item);
    Thread *thread = (Thread *) item;
    if ( ! removed ) {
	thread = 0;
    }
    return( thread );
}

Thread *
FifoScheduler::remove(Thread *t)
{
    AwesimeFifoItem item = (AwesimeFifoItem) t;
    bool removed = fifo.remove(&item);
    assert2( removed, " Attempted to remove non-existent item");
    return(t);
}

bool FifoScheduler::isEmpty()
{
    return(fifo.isEmpty());
}

unsigned int FifoScheduler::size()
{
    return(fifo.size());
}

void FifoScheduler::classPrintOn(ostream& s)
{
    s << "[FifoScheduler] " << fifo;
}
