# Function:
	.text
define(THREAD_FP,   0($1))
define(THREAD_SP,  4($1))
define(THREAD_BASE,8($1))
define(THREAD_END, 12($1))
define(THREAD_MAX, 16($1))

define(CONTEXT_FROM, 8(fp))		# pointer to object instance
define(CONTEXT_TO, 12(fp))		# first arg

# Thread::exchj() -- Thread exchange jump (co--routine call)
#
# Transfer control from the active process to a new process.
#
	.text
#ifdef	__Cplusplus__
	.globl	__HardwareContext_magicSwitchTo
__HardwareContext_magicSwitchTo:
#endif
#ifdef	__GNUG__
	.globl _magicSwitchTo_PSHardwareContext_PSHardwareContext
 _magicSwitchTo_PSHardwareContext_PSHardwareContext:
#endif
	enter	[r1,r2,r3,r4,r5,r6,r7],$0
	movl	f0,tos
	movl	f2,tos
	movl	f4,tos
	movl	f6,tos

	movd	CONTEXT_FROM,r0
	sprd	fp,THREAD_FP(r0)	# save the current FP
	sprd	sp,THREAD_SP(r0)

	movd	CONTEXT_TO,r0		# r0 = address of dst Thread object
	lprd	fp,THREAD_FP(r0)	# load FP of destination Thread
	lprd	sp,THREAD_SP(r0)	# load Sp of destination

	movl	tos,f6
	movl	tos,f4
	movl	tos,f2
	movl	tos,f0
	exit	[r1,r2,r3,r4,r5,r6,r7]
	ret	$0
	
	.text
#ifdef	__Cplusplus__
	.globl __HardwareContext_getSp
__HardwareContext_getSp:
#endif
#ifdef	__GNUG__
	.globl _getSp_PSHardwareContext
_getSp_PSHardwareContext:
#endif
	sprd	sp,r0			# load the FP into the return reg
	ret	$0
