// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef SEMAPHOREH
#define SEMAPHOREH
#pragma once

//
//	Semaphore.h
//
//	This implements a general counting semaphore. Each semaphore has
//	a value known as 'count', which can be initialized to any value.
//
//	When count is < 1, and a process attempts to reserve the semaphore,
//	that process is suspended. If count > 1, then the process continues.
//	In either case, the count is decremented.
//
//	When releasing a semaphore, the count is incremented. If the count
//	was less than 1, a single waiting process (if any is waiting) is
//	allowed to proceed.
// 

#include <ReserveByException.h>
#include <SpinLock.h>
#include <ThreadContainer.h>

class Semaphore : public ReserveByException {

protected:
    SpinLock lock;
    ThreadContainer *pScheduler;
    int pCount;
    char iDidAlloc;

private:
    virtual int reserveByException( Thread *byWho );
    
public :

    Semaphore(int count = 1, ThreadContainer *scheduler = 0);
    virtual ~Semaphore();

    virtual void reserve();
    virtual void release();
    virtual bool reserveNoBlock();

    virtual unsigned size();

    //
    //	You should not change the count when threads are blocked
    //
    virtual int count();
    virtual int count(int count);
    virtual void incrCount(int increment);

    bool isEmpty();
};

inline bool
Semaphore::isEmpty()
{
    return( size() == 0);
}

#endif SEMAPHOREH
