// This may look like C code, but it is really -*- C++ -*-
// 
// Copyright (C) 1988 University of Illinois, Urbana, Illinois
// Copyright (C) 1989 University of Colorado, Boulder, Colorado
// Copyright (C) 1990 University of Colorado, Boulder, Colorado
//
// written by Dirk Grunwald (grunwald@foobar.colorado.edu)
//
#ifndef _ThreadHeap_h
#define _ThreadHeap_h
#pragma once

#include <Thread.h>

#define HEAP_NAME ThreadHeap

class ThreadHeapItem {
    Thread *ptr;
public:
    ThreadHeapItem();
    ThreadHeapItem(Thread *p);
    operator<=(ThreadHeapItem &p);
    Thread *thread();
};

inline Thread*
ThreadHeapItem::thread()
{
    return(ptr);
}

inline ThreadHeapItem::ThreadHeapItem()
{
    ptr = 0;
}

inline ThreadHeapItem::ThreadHeapItem(Thread *p)
{
    ptr = p;
}

inline int ThreadHeapItem::operator<=(ThreadHeapItem &p)
{
    return(ptr -> priority() <= (p.thread() -> priority()));
}

#include <GenericHeap.h>
#endif /* ThreadHeap */

