-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "assoc_sym.t"
#include "isittype.t"
#include "mergestate.t"

export closure;

-- closure grammar
--	Given a grammar, return a list describing what states can be
--	reached, and what reductions can be made for each nonterminal
--	symbol.  Return value is an association list where the "index"
--	is nonterminal symbols, and the "value" is a pair.  The first
--	component describes the items that can be reached on a shift
--	when "dot" is at the left of the choosen symbol.  The second
--	component is the set of reductions possible in the same case.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/closure.m,v 1.1 88/04/19 17:04:51 pelle Exp $"
and
    closure (grammar as prod,$,nont,$,$,$,$,$,$,$,$) first nullable =
    	let
	    prodl =
	    	((map extract o group eq o sort less) prod
	    	where
		    less (nt1,$,$,$,$) (nt2,$,$,$,$) = nt1 < nt2
	    	and
		    eq (nt1,$,$,$,$) (nt2,$,$,$,$) = nt1 = nt2
	    	and
		    extract (l as (nt,$,$,$,$).$) =
		    	nt, map (\ ($,rhs,$,$,no) . (rhs,no)) l)
    	in let
	    redact = (mapsnd (sort (<) o reduce red []) prodl
	    where
		red ([],num) rest = num.rest
	    ||  red ($.$,$) rest = rest)
    	and
	    directprod = (mapsnd (reduce direct []) prodl
	    where
	    	direct ([],$) rest = rest
	    ||  direct (hd.tl,num) rest =
		    (hd,([num,length tl],[tl])).rest)
	and
	    local
		local
		    find sym = reduce fnd (Isn't,[])
		    where
			fnd (this as s,c) (sel,rst) =
			    if s = sym then Is c,rst else sel,this.rst
		in
		    newdep true ctxt (sym,symct) (dir,ind) =
			case find sym ind in
			    Isn't,ind :
			    	case find sym dir
				in  Isn't,dir :
					(sym,NSunion ctxt symct).dir, ind
				||  Is c,dir' :
					(sym,NSunion ctxt (NSunion c symct))
					    .dir',
					ind
				end
			||  Is c,ind' :
				(sym,NSunion ctxt (NSunion c symct)).dir, ind'
			end
		||  newdep false ctxt (sym,symct) (dir,ind) =
			case find sym ind
			in  Isn't,ind :
				case find sym dir
				in  Isn't,dir :
					dir, (sym,NSunion ctxt symct).ind
				||  Is c,dir' :
					(sym,NSunion ctxt (NSunion c symct))
					    .dir',
					ind
				end
			||  Is c,ind' :
				dir, (sym,NSunion ctxt (NSunion c symct)).ind'
			end
		end
	    in local
		produce0 = map (\ (sym,$) . sym,([sym,NSempty],[])) prodl
	    and
		step app = (mapsnd stp1 app
		where
		    stp1 (dep as dir,ind) =
			(let
			   dir,ind =
				reduce
				    (stp2 true)
				    (reduce (stp2 false) dep ind)
				    dir
			in
			    sort lt dir, sort lt ind)
		    where
			lt (sym1,$) (sym2,$) = sym1 < sym2
		    and
			stp2 isdir (sym,ctxt) dep =
			    (let dirstp,indstp = assoc_sym sym prdcstep in
			    let dep1 = reduce (newdep isdir ctxt) dep dirstp in
			    reduce (newdep false NSempty) dep1 indstp)
			where
			    prdcstep = mapsnd (reduce prdc ([],[])) prodl
	    		    where
				prdc (hd.tl,$) dep & (mem hd nont) =
				    newdep
					(nullable tl)
					NSempty
					(hd,first tl)
					dep
			    ||	prdc $ dep = dep)
	    and rec
		fix (h1.tl as h2.$) = if h1 = h2 then h1 else fix tl
	    in
	    	produces = fix prodapp
	    	    where rec prodapp = produce0 . map step prodapp
	    end end
	in
-- TEMP FIX	    mapsnd getnext produces
	    mapsnd getnext (snd (produces,produces))	-- TEMP FIX
	    where
		getnext (dir,ind) =
		    (let
			dep,depred = reduce next ([],[]) dir
		    and
			indep,indepred = reduce next ([],[]) ind
		    in
			(dep,indep),(depred,indepred))
		where
		    next (sym,ctxt) (is,rs) =
-- TEMP FIX			reduce merge is (map mkitem (assoc_sym sym directprod)
			reduce merge is							-- TEMP FIX
			    (map mkitem (assoc_sym sym (snd (directprod,directprod)))	-- TEMP FIX
			where
			    mkitem (s,(core,rhs)) =
				[s,((core,[ctxt]),rhs)]),
-- TEMP FIX			mergered rs (map (,ctxt) (assoc_sym sym redact))
			mergered rs (map (,ctxt) (assoc_sym sym (snd (redact,redact))))	-- TEMP FIX

end
