-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

#include <FILE>
#include <OK>
#include "getargs.t"
#include "code.t"
#include "grammar.t"
#include "isittype.t"
#include "lex.t"
#include "printerror.t"
#include "printprog.t"
#include "printverbose.t"
#include "syntax.t"
#include "transition.t"
#include "unlex.t"

case " $Header: /usr/src/local/lml/contrib/fpg/RCS/main.m,v 1.1 88/04/19 17:05:08 pelle Exp $" in $.$:x end where x =
let
    isitfile,spl,verbose,errs = getargs argv
in
    if ~ null errs then fail (concmap printerror errs) else
    let
	file = case isitfile in Is f:f || Isn't:fail "No input file!" end
    in let
	inp = case openfile(file@".ff") in Yes inp:inp || No err:fail err end
    in let
    	parse_tree =
    	    case prs (lex inp) in
	    	Yes pt : pt
	    ||  No syms : fail ("Syntax error at:" @ unlex (head 10 syms))
	    end
    in let
    	grammar, errs = mkgrammar parse_tree
    in
    	if ~ null errs then fail (concmap printerror errs) else
	let
	    trans = transitions grammar
	in let
	    acts, comm = split trans
	in let
	    warn = concmap fst comm
	in
	    (if null warn then "" else printwarning warn) @
    	    (if verbose then TOFILE(file@".v") @ printverbose grammar trans else "") @
    	    concmap
    	    	(@"\n")
		(concmap
	    	    (\ (suffix,modle) .
		    	let lines as l1.ls = printmodule 80 4 0 modle
			in (TOFILE(file@suffix) @ l1) . ls)
		    (code file spl grammar acts))
