-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "assoc_sym.t"
#include "first.t"
#include "closure.t"
#include "mergestate.t"

export nextfunc;

-- nextfunc grammar
--	Create a function which, when applied to a state in the form
--	of a core/context lists pair and corresponding list of
--	right-hand-sides of productions, returns a list of symbol/new
--	state pairs.  These new states represent the states one
--	reaches after a shift of the associated symbol.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/next.m,v 1.1 88/04/19 17:05:09 pelle Exp $"
and
    nextfunc grammar =
	let
	    first,nullable = firstf grammar
	in let
-- TEMP FIX	    close s =
-- TEMP FIX		let
-- TEMP FIX		    closures = closure grammar first nullable
-- TEMP FIX		in
	    closures = closure grammar first nullable	-- TEMP FIX
	in let						-- TEMP FIX
	    close s =					-- TEMP FIX
		    assocdef_sym s closures (([],[]),([],[]))
	in let
	(rec
	    red3 f x [] [] [] = x
	||  red3 f x (h1.t1) (h2.t2) (h3.t3) = f h1 h2 h3 (red3 f x t1 t2 t3))
	and
	    check (p,0) ctxt [] (fnditm,fndred) =
		fnditm, mergered [p,ctxt] fndred
	||  check (p,r) ctxt (rhs1.rhs) (fnditm,fndred) =
		(merge
		    (merge
			[rhs1,(([p,r-1],[ctxt]),[rhs])]
			(merge dep indep))
		    fnditm,
		mergered
		    (mergered (mapsnd (NSunion nctxt) depred) indepred)
		    fndred
		where rec
		    (dep1,indep),(depred,indepred) = close rhs1
		and
		    dep = mapsnd (insertctxt nctxt) dep1)
		where
		    nctxt =
			NSunion
			    (if nullable rhs then ctxt else NSempty)
			    (first rhs)
		and
		    insertctxt nctxt ((core,octxt),rhs) =
			(core,map (NSunion nctxt) octxt), rhs
	in
-- TEMP FIX	    uncurry (red3 check ([],[]))
	    snd (closures,uncurry (red3 check ([],[])))	-- TEMP FIX

end
