-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "actions.t"
#include "conflicttype.t"

-- printverbose grammar states :
--	Produce a verbose output of the states "states" for human consumption.

export printverbose;

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/printverbose.m,v 1.1 88/04/19 17:05:11 pelle Exp $"
and
    printverbose ($,$,$,$,$,$,lookup,iattr,sattr,$,$) states =
	mix (map printstate (sort numord states)) "\n" @
	"Synthesized attributes:\n\n" @ printattribute sattr @
	"Inherited attributes:\n\n" @ printattribute iattr
	where
	    numord ((n1,$,$),$) ((n2,$,$),$) = n1 < n2
	and
	    printstate ((num,nontact,termact),(warn,items)) =
		(concmap printwarn warn @
		"state " @ itos num @ "\n" @
		concmap printitem items @ "\n" @
		concmap printact termact @ "\n" @
		concmap printact nontact
		where
		    printwarn (ShiftReduce sym shno reno) =
			itos num @ ": shift/reduce conflict (shift " @
			itos shno @ ", red'n " @ itos reno @
			") on " @ lookup sym @ "\n"
		||  printwarn (ReduceReduce sym rno1 rno2) =
			itos num @ ": reduce/reduce conflict (red'ns " @
			itos rno1 @ " and " @ itos rno2 @
			") on " @ lookup sym @ "\n"
		and rec
		    printitem (lhs,ldot,rdot,prodno) =
			"\t" @ lookup lhs @ " : " @
			mix (map lookup ldot) " " @ "_" @
			mix (map lookup rdot) " " @
			"\t(" @ itos prodno @ ")\n"
		and
		    printact (sym, Shift n) =
			"\t" @ lookup sym @ "\tshift " @ itos n @ "\n"
		||  printact (sym, Reduce n) =
			"\t" @ lookup sym @ "\treduce " @ itos n @ "\n")
	and
	    printattribute = conc o map print_symbattr
	    where
    		print_symbattr (symb,atts) =
		    '\t' . lookup symb @ ": " @ mix atts ", " @ "\n"

end
