----------------------------------------------------
--	ALGORITHMS
---------------------------------------------------------

module

#include "aux.t";
#include "setbag.t";
#include "abssyx.t";

export red, chtype, eq_p, eq_l, eq_f, vars_p, vars_f,
       varset, rename, eqts, eqnfschemes;
rec

 --  Reduction to normal form 

 -- reduce the top-level redex (if any) and try again 
    red (Ar Ap [r; Ar Ap [s;t]]) = red (Ar Ap [X Ap [r;s]; t]) 
 || red (Ar Ap [r;  X Ap [s;t]]) = 
			let r0 = red r
		        in X Ap [red(Ar Ap [r0;s]); red(Ar Ap [r0;t])]
 -- otherwise, propagate down		
 || red (ope Ap args) = ope Ap map red args
 || red (V var)	      = V var

and

 -- Convert irreducible expressions from 'texp' to 'normal_form'
 
    chtype (Ar Ap [r; V var]) = singleton_bag (chtype r  Arr VV var)
 || chtype (Ar Ap [r; Other ope Ap args]) = singleton_bag 
						(chtype r 
						 Arr 
						 (ope App map chtype args))
 || chtype (Ar Ap [r; _])      = fail "not normal" 
 || chtype ( X Ap [r; s])      = bag_union (chtype r) (chtype s)
 || chtype (V var     )        = singleton_bag (empty_bag Arr VV var)
 || chtype (Other ope Ap args) = singleton_bag (empty_bag Arr 
					     (ope App map chtype args))
and

--  T-equality on normal forms
--  eq_p : product -> product -> bool
--  eq_l : product list -> product list -> bool
--  eq_f : factor -> factor -> bool
 

    eq_p p1 p2  =  bag_equal eq_f p1 p2
and
    eq_l p1s p2s = list_equal eq_p p1s p2s
and
    eq_f (p1 Arr VV var1) 
 	 (p2 Arr VV var2)       = (var1 = var2) & (eq_p p1 p2)
 || eq_f (p1 Arr (ope1 App args1)) 
	 (p2 Arr (ope2 App args2)) = (ope1 = ope2) & 
				     (eq_l args1 args2) &
				     (eq_p p1 p2)
 || eq_f (_  Arr VV _  )
	 (_  Arr (_ App _))  = false
 || eq_f (_  Arr (_ App _))
	 (_  Arr VV _  )     = false
and

--  R,T-equality on arbitrary expressions
--  equiv : texp -> texp -> bool
-- 
--  equiv e1 e2 = eq_p (chtype (red e1)) (chtype (red e2))


--  vars_p : Product -> Bag Variable 
--  vars_f : Factor  -> Bag Variable 

    vars_f (p Arr VV var)  = bag_union (singleton_bag var) 
				       (vars_p p)
 || vars_f (p Arr
	    (ope App args)) = bag_union (bag_flat (bag_of_list (map vars_p 
								    args)))
				        (vars_p p)
and 
    vars_p  p  =  bag_flat (bag_map vars_f p)
and

--  varset : Product -> Set Variable 
    varset = set_of_bag o vars_p
and

#define Renaming (Variable -> Variable)
--  rename : Renaming -> Product -> Product 

    rename r p =
      let rec
              rename_f (p Arr VV var) = rename_p p 
				        Arr 
				        VV (r var)
       	   || rename_f (p Arr (ope App args)) =
				        rename_p p 
				        Arr 
				        (ope App map rename_p args)
	  and
    	      rename_p  p  =  bag_map rename_f p
      in
      rename_p p
and

-- equivalent type-schemes, including alpha-convertibility 
--  eqts : Texp -> Texp -> Bool

    eqts s1 =
      let    p1    = chtype (red s1)
      in let vars1 = varset p1
         in
           \s2. 
           let    p2     = chtype (red s2)
	   in let vars2  = varset p2
	      in
    	         set_exists (\r. eq_p (rename r p1) p2) 
		      	    (bijections vars1 vars2)
and

-- equivalent type-schemes, already on normal form
--  eqnfschemes : Product -> Product -> Bool

    eqnfschemes p1 =
      let vars1 = varset p1
      in
        \p2.
	let vars2 = varset p2
	in
	   set_exists (\r. eq_p (rename r p1) p2)
		      (bijections vars1 vars2)


end

