--  style.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- The style package generates a particular consistent style of
-- interaction, it is a collection of useful dialogues.

module

#include "ps.t"
#include "munout.t"
#include "munin.t"
#include "tree.t"
#include "gdc.t"

export CanvasType,ObjType,
       InitDS,Canvas,OutlineCanvas,PopCanvas,OutlinePopCanvas,ClearCanvas,
       OpenFixedWindow,Golden,SWindow,
       BoxAnimate,WaitForLftDep,SDrawButton,SDrawConfirm,ConfirmedExit,
       DoOn,
       SInMs,SRevokeMs,
       SInMsEn,SInMsEx,
       SIsMs,SChangeCursor,SFill,SAnimate,
       SBitmap,SText,SCentredText,SKillCanvas,SKillDecendants,
       SDraw,SLineDraw,PrintTree,TreeCase,Obj,DeleteObjs,Objects,
       Inherit,MoveCard;

rec type CanvasType = TreeType Int +
		      DummyCanvas

and type ObjType *m *s =  
	    OCons *m (*s->(List EventType)->Bool)
	    ((List (ObjType *m *s))->*s->(List EventType)->(DlgCombType *s)) +
	     DummyTC

------------------------------
-- DS manipulation routines --
------------------------------

and InitDS = (100,NewTree 1)

and AddCan a n p ((next,t),s) = ((next+1,AddChild a n p t),s)

and Canvas name prnt org rorg ang scl col shp ((n,t),s) l =
    DC (OpenCanvas n org rorg ang scl (NodeNum (prnt t)) col shp)  
       (AddCan name n (NodeNum (prnt t)) ((n,t),s)) l

and OutlineCanvas name prnt org rorg ang scl w col shp ((n,t),s) l =
    DC (OpenOutlineCanvas n org rorg ang scl w (NodeNum (prnt t)) col shp)  
       (AddCan name n (NodeNum (prnt t)) ((n,t),s)) l

and PopCanvas name prnt org rorg ang scl col shp ((n,t),s) l =
    DC (OpenPopCanvas n org rorg ang scl (NodeNum (prnt t)) col shp) 
       (AddCan name n (NodeNum (prnt t)) ((n,t),s)) l

and OutlinePopCanvas name prnt org rorg ang scl w col shp ((n,t),s) l =
    DC (OpenOutlinePopCanvas n org rorg ang scl w (NodeNum (prnt t)) col shp) 
       (AddCan name n (NodeNum (prnt t)) ((n,t),s)) l

and ClearCanvas name prnt org rorg ang scl shp ((n,t),s) l =
    DC (OpenClearCanvas n org rorg ang scl (NodeNum (prnt t)) shp)
       (AddCan name n (NodeNum (prnt t))((n,t),s)) l

and SWindow prnt org size col ((n,t),s) l =
    DC (OpenPopWindow n org size (NodeNum (prnt t)) col)
       (AddCan 0 n (NodeNum (prnt t))((n,t),s)) l

and BoxAnimate sz = Animate Screen 0 (100^100) (Ghost (Rect sz)) @
		    InAllMs Lft Dep Screen

and WaitForLftDep = Cond (IsAllMs Lft Dep) NullDialogue
		    (Join RejectInput WaitForLftDep)

and OpenFixedWindow size col = 
   let rec Open sz cl ((nextcan,tree),s) (AllMs b a cn pos. t) =
	      DC (RevokeAllMs Lft Dep @ RevokeAnimate @ 
		    OpenPopWindow nextcan pos sz Screen cl)
	      (AddWin ((nextcan,tree),s)) t

    and    AddWin ((nextcan,tree),s) = 
	      ((nextcan + 1,AddChild 0 nextcan 0 tree),s)

   in Seq [Send (BoxAnimate size); WaitForLftDep; Open size col]

-------------------
-- Useful Shapes --
-------------------

and Golden n = (144*n)^(100*n)

------------------------------------
-- GDC commands that work with DS --
------------------------------------

and DoOn cf f ((n,t),s) = Send (f (NodeNum (cf t))) ((n,t),s)

and SInMs b a f ((n,t),s) = Send (InMs b a (NodeNum (f t))) ((n,t),s)

and SInMsEn f ((n,t),s) = Send (InMsEn (NodeNum (f t))) ((n,t),s)

and SInMsEx f ((n,t),s) = Send (InMsEx (NodeNum (f t))) ((n,t),s)

and SRevokeMs b a f ((n,t),s) =
    Send (RevokeMs b a (NodeNum (f t))) ((n,t),s)

and SIsMs b a f ((n,t),s) = IsMs b a (NodeNum (f t)) ((n,t),s)

and SFill f col ((n,t),s) = Send (Fill (NodeNum (f t)) col) ((n,t),s)

and SDraw f org rorg a scl col shp ((n,t),s) =
    Send (Draw (NodeNum (f t)) org rorg a scl col shp) ((n,t),s)

and SLineDraw f org rorg a scl wd col shp ((n,t),s) = 
    Send (LineDraw (NodeNum (f t)) org rorg a scl wd col shp) ((n,t),s)

and SChangeCursor f b ((n,t),s) =
    Send (ChangeCursor (NodeNum (f t)) b) ((n,t),s)

and SAnimate f a scl shp ((n,t),s) =
    Send (Animate (NodeNum (f t)) a scl shp) ((n,t),s)

and SBitmap f pos scl str ((n,t),s) =
     Send (Bitmap (NodeNum (f t)) pos scl str) ((n,t),s)

and SText f pos fnt scl col str ((n,t),s) = 
    Send (Text (NodeNum (f t)) pos fnt scl col str) ((n,t),s)

and SCentredText f pos fnt scl col str ((n,t),s) = 
    Send (CentredText (NodeNum (f t)) pos fnt scl col str) ((n,t),s)

and SKillCanvas f ((n,t),s) l = 
   DC (KillCanvas (NodeNum (f t))) ((n,(DelChild (NodeNum (f t)) t)),s) l

and SKillDecendants f ((n,t),s) =
   (if Child (f t) = Empty then NullDialogue
   else Join (SKillCanvas (Child  o f)) (SKillDecendants f)) ((n,t),s)

and SDrawButton pos (Cart w h) prnt col str ((n,t),s) =
	   Seq [OutlineCanvas 0 prnt pos (0^0) 0 (100^100) 8 col
		(RoundRect (Cart w h) 20);
		Send (CentredText n (Cart (w/2) (h/2)) HelveticaBold 30
		Black str);
	        Send (ChangeCursor n Bullseye);
		MsInterest Lft Dep n] ((n,t),s)

and     SDrawConfirm prnt =
           Seq [SWindow prnt (100^100) (250^150) White;
                SCentredText (Child o prnt) (125^125) HelveticaBold 30 Black
                "Are you sure ?";
                SDrawButton (35^10) (90^90) (Child o prnt) Red "No!!";
		SInMs Lft Dep (Child o Child o prnt);
                SDrawButton (135^10) (90^90) (Child o prnt) SpringGreen "Yes";
		SInMs Lft Dep (Child o Child o prnt)]
 
and ConfirmedExit prnt cl = Join (SDrawConfirm prnt) (WaitForYesNo prnt cl)

and WaitForYesNo prnt cl =
    let rec KillConfirm = SKillCanvas (Child o prnt)
    and     YesCan = Child o Child o prnt
    and     NoCan  = EldestChild o Child o prnt
    in Cond (SIsMs Lft Dep YesCan) KillConfirm
            (Cond (SIsMs Lft Dep NoCan) (Join KillConfirm (TreeCase cl))
                  (Join RejectInput (WaitForYesNo prnt cl)))

and PrintNode (Tree n a u d l r) = 
    "Node:" @ itos n @ " Parent: " @ itos (NodeNum u) @ "\n"

and PrintTree = DepthTraverse PrintNode

----------------------------------
-- Object manipulation routines --
----------------------------------

and TreeCase d = SubTreeCase d d

and SubTreeCase d [] = Join RejectInput (SubTreeCase d d)
||  SubTreeCase d ((OCons m c a).t) = Cond c (a d) (SubTreeCase d t)

and Obj l cl = Seq (l @ [TreeCase cl])

and DeleteObjs f [] = []
||  DeleteObjs f (OCons tag c a.t) = if f tag then DeleteObjs f t
				     else OCons tag c a . DeleteObjs f t

/*and Objects ol cl =
    let (Dgs,Rls) = split ol
    in Seq (Dgs @ [TreeCase (conc Rls @ cl)])
*/

and Objects [] cl = TreeCase cl
||  Objects ((dlg,rf).t) cl = Join dlg (SubObjects rf t cl)

and SubObjects rf rest cl s l = Objects rest (rf s l @ cl) s l

and Inherit (D1,R1) (D2,R2) = (Join D1 D2, ComposeRuleFuns R1 R2)

and ComposeRuleFuns r1 r2 s l = r1 s l @ r2 s l 

and MoveCard size f cl ((n,t),s) =
   let rec SubMoveCard st (AllMs Lft Dep cn pos. rest) =
           DC (MoveCanvas (NodeNum (f t)) pos) st rest
   in Seq [Send (BoxAnimate size); WaitForLftDep; Send(RevokeAnimate);
           SubMoveCard; Send(RevokeAllMs Lft Dep); TreeCase cl] ((n,t),s)

end
