module
#include "fmatrix.t"
#include "stream.t"
#include "floatop.t"
export lap;

rec
    f0 = float 0
and f4 = float 4
and relax n A =
	mkmat n (\x.\y.
		if x = 1 | x = n | y = 1 | y = n then
			A[x,y]
		else
			(A[x-1,y] .+ A[x+1,y] .+ A[x,y-1] .+ A[x,y+1]) ./ f4)
and convp n A1 A2 d = mreduce n fmax (mmap n fabs (mmap2 n (.-) A1 A2)) .< d
and pickconv n delta (A1::A2::As) =
	if convp n A1 A2 delta then
		A2
	else
		pickconv n delta (A2::As)
and lap max bounds delta =
	let A0 = mkmat max bounds in
	let rec As = A0 :: smap (relax max) As in
	pickconv max delta As
end
