module
#include "matrix.t"
#include "tetr.t"
#include "misc.t"
export startboard, drawboard, b_set, setb, hitb, bmove,
	outside, droppos, updscore, score, inclevel, getlevel;
-- the board, lines removed, points, level
rec (type Board = B (List (List Char)) Int Int Int)
and startboard l = B (m_create xsize ysize blank) 0 0 l
and blank = ' '
and xoffs = 5
and yoffs = 1
and xsize = 10
and ysize = 20
and xinfo = 25
and yinfo = 4
and drawpoints (B b rows points level) =
	MoveTo xinfo (yinfo+2) @ "Points " @ itosf 5 points
and drawboard (board as B b rows points level) =
	MoveTo xoffs yoffs @ "<" @ rept xsize '^' @ ">" @
	conc (for 1 ysize (\i.MoveTo xoffs (yoffs+i) @ "'" @
			      (select i b) @
			      "|")) @
	MoveTo xoffs (yoffs+1+ysize) @ "\"" @ rept xsize '_' @ ":" @
	MoveTo xinfo yinfo @ "Lines  " @ itosf 5 rows @ 
	drawpoints board @ 
	MoveTo xinfo (yinfo+4) @ "Level  " @ itosf 5 level @
	endstring
and tcoord t (sx,sy) = filter (\(x,y).y>=1) (map (\(x,y).(x+sx,y+sy))(coord t))
and b_set t xy = bchg (tcoord t xy) (charof t) @ endstring
and bchg xys c = concmap (\(x,y).MoveTo (xoffs+x) (yoffs+y) @ [c]) xys
and bmove st dt sxy dxy =
	let src = tcoord st sxy
	and dst = tcoord dt dxy in
	let res = difference src dst
	and set = difference dst src
	in bchg set (charof dt) @ bchg res blank @ endstring
and droppos b (xy as (x,y)) t =
	if hitb b xy t then
		xy
	else
		droppos b (x,y+1) t
and setb (B b rows points level) (x,y) t =
	let c = charof t in
	let b' = reduce f b (coord t)
		   where f (dx,dy) b =  if y+dy < 1 then b
					else m_update b (x+dx) (y+dy) c in
	let nfull = length (filter fullrow b') in
	if nfull ~= 0 then
		let b'' = rept nfull (rept xsize blank) @ filter (not o fullrow) b' in
		let level' = newlevel (rows+1) level in
		let board = B b'' (rows+1) points level'
		in (flash b' @ dodelay level' @ drawboard board, board)
	else
		let board = B b' rows points level in
		(drawpoints board, board)
and drawrow i r = MoveTo (xoffs+1) (yoffs+i) @ r
and flashdelay = 200
and flash b = 
	let fullrows = filter (\(y,r).fullrow r) (map2 (\y.\r.(y,r)) (from 1) b) in
	conc (rept 3 (
	concmap (\(y,r).drawrow y (rept xsize blank)) fullrows @ endstring @ delay flashdelay @
	concmap (\(y,r).drawrow y r) fullrows @ endstring @ delay flashdelay))
and fullrow r = all (~= blank) r
and hitb (B b _ _ _) (x,y) t =
	exists (\(dx,dy). y+dy+1 > ysize | m_sub b (x+dx) (y+dy+1) ~= blank) (coord t)
and outside (B b _ _ _) (x,y) t =
	(exists bad (coord t)
	   where bad (dx,dy) = x+dx < 1 | x+dx > xsize | y+dy > ysize | y+dy >= 1 & m_sub b (x+dx) (y+dy) ~= blank)
and updscore (B b rows points level) (sx,sy) (dx,dy) =
	let p = 2*level + sy + dy/2 + 5 in
	let b' = B b rows (points+p) level in
	(drawpoints b', b')
and score (B _ _ s _) = s
and inclevel (B b r p l) = B b r p (if l<9 then l+1 else l)
and getlevel (B _ _ _ l) = l
end
