module -- apconv
--
-- Transform application and lambda chains to simplify lambda lifting.
--
-- $Header: /ufs/usr.src/local/lml/src/Expr/RCS/apconv.m,v 97.0 90/07/07 14:36:28 augustss Exp $
--
#include "../misc/misc.t"
#include "../expr/einfo.t.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "Expr.t.t"
export apconv;
rec

    apconv e = apcnv e
where rec
    -- remove type restrictions, they are not needed any more.
    minfo (restr _) e = e
||  minfo f e = Einfo f e
and apcnv (Eap f a) = apchain [a] f
||  apcnv (Elam i e)= lamchain [i] [] e
||  apcnv (Ecase e1 pl de) =
	Ecase (apcnv e1) (mapthd apcnv pl) (apcnv de)
||  apcnv (Elet r dl e) = Elet r (mapsnd apcnv dl) (apcnv e)
||  apcnv (Emodule i exp dl) = Emodule i exp (map (mapsnd apcnv) dl)
||  apcnv (Econstr c el) = Econstr c (map apcnv el)
||  apcnv (Evar i) = Eidapl i []
||  apcnv (Efailmatch n) = Efailmatch n
||  apcnv (Einfo f e) = minfo f (apcnv e)
||  apcnv _ = fail "apcnv"
and
    lamchain il al (Elam i e) = lamchain (il@[i]) al e
||  lamchain il al e = Elamapl il (apcnv e) (map apcnv al)
and
    apchain al (Eap f a) = apchain (a.al) f
||  apchain al (Elam i e)= lamchain [i] al e
||  apchain al (Ecase e1 pl de) =
	Ecase (apcnv e1) (mapthd (apchain al) pl) (apchain al de)
||  apchain al (Elet r dl e) = Elet r (mapsnd apcnv dl) (apchain al e)
||  apchain al (Evar i) = Eidapl i (map apcnv al)
||  apchain al (Efailmatch n) = Efailmatch n
||  apchain al (Einfo f e) = minfo f (apchain al e)
||  apchain al _ = fail "strange apchain expr"
end
