module -- predef
-- Insert predefined identifiers where possible.
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/einfo.t.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t"
#include "../Expr/Expr.t.t"
#include "../transform/hexpr.t"
#include "../misc/util.t"
#include "../misc/misc.t"
#include "../misc/flags.t"
#include "../rename/renenv.t"
#include "../rename/import.t"
#include "../funnos.h"
#include "../expr/constrfun.t"
#include "../transform/exprs.t"
export predef, pre_add, pre_sub, pre_neg;
rec predef e = lpre e

and lpre (Ecase e1 cl e2) = Ecase (lpre e1) (mapthd lpre cl) (lpre e2)
||  lpre (Elet r dl e) = Elet r (mapsnd lpre dl) (lpre e)
||  lpre (Emodule i expl dl) = Emodule i expl (map (mapsnd lpre) dl)
||  lpre (Econstr c []) & (isrational c) = torat c
||  lpre (Econstr (cc as Cconstr s a b _ c) _) & (isstring cc) = -- translate short strings into lists
	case length s in
	   0 : Econstr hcnil []
	|| 1 : Econstr hccons [Econstr (xcchar (hd s)) [] ; Econstr hcnil []]
	|| _ : Econstr hccons [Econstr (xcchar (hd s)) [] ; Econstr (Cconstr (tl s) a b (-1) c) [] ]
	end
||  lpre (Econstr c el) = Econstr c (map lpre el)
||  lpre (e as Efailmatch n) = e
-- Next 4 are for Haskell only
||  lpre (Eidapl iand [e1; e2]) & (Curry & eqid iand hiand) = 
	Ecase (lpre e1) [(hcfalse, [], Econstr hcfalse []); (hctrue, [], (lpre e2))] (Efailmatch 0)
||  lpre (Eidapl ior  [e1; e2]) & (Curry & eqid ior  hior)  = 
	Ecase (lpre e1) [(hcfalse, [], (lpre e2)); (hctrue, [], Econstr hctrue  [])] (Efailmatch 0)
||  lpre (Eidapl inot [e]) & (Curry & eqid inot hinot) = 
	Ecase (lpre e) [(hcfalse, [], Econstr hctrue []); (hctrue, [], Econstr hcfalse  [])] (Efailmatch 0)
||  lpre (Eidapl iother []) & (Curry & eqid iother hiotherwise) = Econstr hctrue []
||  lpre (Eidapl i es) = 
    let es' = map lpre es in
    case assocdefeq eqid i pretab i in
	(ni as mkid _ _ (idi_var (var_pre (finfo n _ _ _)) _) _) & (length es = n) : Eidapl ni es'
    ||  (ni as mkid _ _ (idi_var (var_global _) _) _) : Eidapl ni es'
    ||  _ : Eidapl i es'
    end
||  lpre (Elamapl is e es) = Elamapl is (lpre e) (map lpre es)
||  lpre (Einfo f e) = Einfo f (lpre e)

and pretab = if Curry then hpretab else lpretab
and lpretab = [
(hiadd, pf Fadd);
(hisub, pf Fsub);
(himul, pf Fmul);
(hidiv, pf Fdiv);
(himod, pf Fmod);
(hinegate, pf Fneg);
(hi_ord, pf Ford);
(hi_chr, pf Fchr);
(hiseq, pf Fseq);
(vf "Ptag", pf Ftag)
]
and pf n = pff n predefs
and pff n [] = fail ("No predef "@itos n)
||  pff n ((i as mkid k _ _ _)._) & (n = k) = i
||  pff n (_.xs) = pff n xs
and pre2  = idi_var (var_pre (finfo 2 [true;true] true 2)) Onotype
and pre2f = idi_var (var_pre (finfo 2 [true;true] false 2)) Onotype
and pre1  = idi_var (var_pre (finfo 1 [true] true 1)) Onotype
and nn = noorigname
and predefs = [
mkid Fadd   "Padd"   pre2  nn;
mkid Fsub   "Psub"   pre2  nn;
mkid Fmul   "Pmul"   pre2  nn;
mkid Fdiv   "Pdiv"   pre2f nn;
mkid Fmod   "Pmod"   pre2f nn;
mkid Fneg   "Pneg"   pre1  nn;
mkid Ford   "Pord"   pre1  nn;
mkid Fchr   "Pchr"   pre1  nn;
mkid Fseq   "Pseq"   pre2  nn;
mkid Feq    "Peq"    pre2  nn;
mkid Fne    "Pne"    pre2  nn;
mkid Flt    "Plt"    pre2  nn;
mkid Fle    "Ple"    pre2  nn;
mkid Fgt    "Pgt"    pre2  nn;
mkid Fge    "Pge"    pre2  nn;
mkid Fbigge "Pbigge" pre2f nn;
mkid Fbigeq "Pbigeq" pre2f nn;
mkid Fbigne "Pbigne" pre2f nn;
mkid Fbiglt "Pbiglt" pre2f nn;
mkid Fbigle "Pbigle" pre2f nn;
mkid Fbiggt "Pbiggt" pre2f nn;
mkid Fcno   "Pcno"   pre1  nn;
mkid Ftag   "Ptag"   pre1  nn
]
and pre_add = pf Fadd
and pre_sub = pf Fsub
and pre_neg = pf Fneg

-- Haskell predefined
and vf s = rfind Kvalue s preenv
and hpretab = [
-- all builtin ops
(vf "MM.Num.Int.+",	pf Fadd);
(vf "MM.Num.Int.-", 	pf Fsub);
(vf "MM.Num.Int.*", 	pf Fmul);
(vf "MM.Num.Int.negate",pf Fneg);
(vf "MM.Integral.Int.div", pf Fdiv);
(vf "MM.Integral.Int.rem", pf Fmod);
(vf "MM.Eq.Int.==", 	pf Feq);
(vf "MM.Eq.Int./=", 	pf Fne);
(vf "MM.Ord.Int.>", 	pf Fgt);
(vf "MM.Ord.Int.>=", 	pf Fge);
(vf "MM.Ord.Int.<", 	pf Flt);
(vf "MM.Ord.Int.<=", 	pf Fle);
(vf "MM.Eq.Char.==", 	pf Feq);
(vf "MM.Eq.Char./=", 	pf Fne);
(vf "MM.Ord.Char.>", 	pf Fgt);
(vf "MM.Ord.Char.>=", 	pf Fge);
(vf "MM.Ord.Char.<", 	pf Flt);
(vf "MM.Ord.Char.<=", 	pf Fle);
(vf "MM.Eq.Bool.==", 	pf Feq);
(vf "MM.Eq.Bool./=", 	pf Fne);
(vf "MM.Ord.Bool.>", 	pf Fgt);
(vf "MM.Ord.Bool.>=", 	pf Fge);
(vf "MM.Ord.Bool.<", 	pf Flt);
(vf "MM.Ord.Bool.<=", 	pf Fle);
(hi_ord,		pf Ford);
(hi_chr,		pf Fchr);
(hicno,			pf Fcno);
(hieqint,		pf Feq);
(hiltint,		pf Flt);
(hileint,		pf Fle);
(hiord,			pf Ford);
-- faster calls to special routines
(vf "MM.Num.Int.fromInteger", vf "PInteger2Int");
(vf "MM.Real.Int.toInteger", vf "PInt2Integer");
(vf "MM.Eq.Integer.==",	pf Fbigeq);
(vf "MM.Eq.Integer./=",	pf Fbigne);
(vf "MM.Ord.Integer.>", pf Fbiggt);
(vf "MM.Ord.Integer.>=",pf Fbigge);
(vf "MM.Ord.Integer.<", pf Fbiglt);
(vf "MM.Ord.Integer.<=",pf Fbigle);
(vf "MM.Num.Integer.+",	vf "PIntegerAdd");
(vf "MM.Num.Integer.-", vf "PIntegerSub");
(vf "MM.Num.Integer.*", vf "PIntegerMul");
(vf "MM.Num.Integer.negate",vf "PIntegerNeg");
(vf "MM.Integral.Integer.div", vf "PIntegerDiv");
(vf "MM.Integral.Integer.rem", vf "PIntegerMod");
(vf "MM.Eq.Float.==",	pf Fbigeq);
(vf "MM.Eq.Float./=",	pf Fbigne);
(vf "MM.Ord.Float.>",   pf Fbiggt);
(vf "MM.Ord.Float.>=",  pf Fbigge);
(vf "MM.Ord.Float.<",   pf Fbiglt);
(vf "MM.Ord.Float.<=",  pf Fbigle);
(vf "MM.Num.Float.+",	vf "DFloatAdd");
(vf "MM.Num.Float.-",   vf "DFloatSub");
(vf "MM.Num.Float.*",   vf "DFloatMul");
(vf "MM.Num.Float.negate",vf "DFloatNeg");
(vf "MM.Fractional.Float./", vf "DFloatDiv");
(vf "MM.Eq.Double.==",	pf Fbigeq);
(vf "MM.Eq.Double./=",	pf Fbigne);
(vf "MM.Ord.Double.>",  pf Fbiggt);
(vf "MM.Ord.Double.>=", pf Fbigge);
(vf "MM.Ord.Double.<",  pf Fbiglt);
(vf "MM.Ord.Double.<=", pf Fbigle);
(vf "MM.Num.Double.+",	vf "DFloatAdd");
(vf "MM.Num.Double.-",  vf "DFloatSub");
(vf "MM.Num.Double.*",  vf "DFloatMul");
(vf "MM.Num.Double.negate",vf "DFloatNeg");
(vf "MM.Fractional.Double./", vf "DFloatDiv")
]

-- Convert a floating point string to a rational number.
-- Assumes that rationals are represented as a pair in Integer.
and torat c =
    let x = cname c in
    let (i,de) = splitat '.' x in
    let (d, e) = take isdigit de in
    let num1 = stoI (i@d)
    and den1 = tenI (length d) in
    let exp = case e in
	          "" : 0
	      ||  _.'+'.s : stoi s	-- skipped char must be 'e' or 'E'
	      ||  _.s : stoi s
	      end in
    let (num2, den2) = if exp < 0 then 
	                 (num1, den1 *# tenI (-exp)) 
		       else 
			 (num1 *# tenI exp, den1) in
    let g = gcdI (absI num2) den2 in
    let den = den2 /# g
    and num = num2 /# g in
    Econstr crat [mkI num; mkI den]
and mkI n = Econstr (mkinteger (Itos n)) []
and crat = Cconstr "_:%" Trational (mktinfo Trational 1 false false []) 0 [(Tarr Tinteger (Tarr Tinteger Trational), false)]

and absI n = if n < 0# then 0# -# n else n
and gcdI n m = if m = 0# then
                  n
	      else
		  gcdI m (n %# m)
and tenI n = 
        if n = 0 then
	    1#
        else
	    let p = tenI (n / 2) in
            if n % 2 = 0 then
		p *# p
	    else
		10# *# p *# p
end
