/*
**	scc:		Find strongly connected components of a graph.
**			The graph is represented as a list of nodes, each
**			node is a pair; the node name and an adjecency list
**			consisting of node names.  It returns a list of
**			strongly connected components.q
**
*/
module
export scc;
rec
    searchc G n low (vv as (v,es)) =
	let n = n+1 in
	let low = (v,n).low in
	let ((n,low,nstack,min),cs) = mapstate f (n,low,[vv],n) es
    	where rec f (n,low,stack,min) w =
    	    let ((n,low,stack',m),cs) =
	    	let vm = assocdef w low 0 in
	    	if vm = 0 then
		    searchc G n low (w, assoc w G)
	        else
		    ((n,low,[],vm),[])
	    in
	    ((n,low,stack'@stack,if m<min then m else min), cs)
	in
	let cs = conc cs in
	if assoc v low = min then
		((n,map (\(x,_).(x,maxint)) nstack @ low,[],min), cs@[nstack])
	else
		((n,low,nstack,min), cs)
and
	scc G =
	let (low, cs) = mapstate g [] G
	    where g low (vv as (v, _)) =
		if assocdef v low 0 = 0 then
			let ((n,low,stack,min), cs) = searchc G 1 low vv
			in (low, cs)
		else
			(low, [])
	in
	conc cs
end
