module
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/einfo.t.t"
#include "../expr/constr.t.t"
#include "../expr/constrfun.t"
#include "../Expr/Eprint.t"
#include "../Expr/Expr.t.t"
#include "../Expr/Eutil.t"
#include "../misc/flags.t"
#include "../funnos.h"
#include "Gcodedef.t.t"
#include "Gmode.t.t"
#include "Gseq.t"
#include "Genv.t"
#include "Gcase.t"
#include "Gtail.t"
#include "Gutil.t"

export G;
rec
   G _ (e as Eidapl i _) _ _ _ _ & (id_ismethod i) =
       fail ("method application "@pr e)

|| G mode (Ecase e pl de) r n fl fs =	Gcase mode e pl de r n fl fs

|| G mode (Efailmatch _) _ _ Notalabel _ = fail "G,failmatch,notalabel"
|| G mode (Efailmatch _) r n fl fs = Gseq [ Gpop (n-fs); Gi [JMP fl] ]

|| G mode (Elet re d e) r n fl fs =
		let (r2,n2) = addenv r (map (\(i,_).i) d) n  in
		let m = n2-n in
		let du = combine (d, from 0) in
		if re then
		    Gseq [ Gi [ ALLOC m ];
		    	   Gseq (map (\((_,e),x).
					Gseq [ G (C n2) e r2 n2 Notalabel 0;
					       Gi [ UPDATE (m-x) ]])
				     du);
			   G mode e r2 n2 fl fs
		    ]
		else
		    Gseq [ Gseq (map (\((_,e),x).G (C(n+x)) e r (n+x) Notalabel 0) du);
		    	   G mode e r2 n2 fl fs
		    ]

|| G m (Einfo (spark is) e) r n fl fs =
		Gseq [	Gspark is r n;
			G m e r n fl fs
		     ]

|| G m (Einfo (doeval is) e) r n fl fs =
		Gseq [	Gdoeval is r n;
			G m e r n fl fs
		     ]

|| G R (Einfo (noarrow _) (Einfo noeval (Eidapl i []))) r n fl fs =
		Gseq [	pushvar i r n 0;
			Gi [ UPDATE 1; RET ]
		]

|| G R (Einfo noeval (Einfo (noarrow _) (Eidapl i []))) r n fl fs =
		Gseq [	pushvar i r n 0;
			Gi [ UPDATE 1; RET ]
		]

|| G R (Einfo (noarrow _) (Eidapl i [])) r n fl fs =
		Gseq [	pushvar i r n 0;
			if gnoargs i <= 0 then
				Gi [ EVAL ]
			else
				Gi [];
			Gi [ UPDATE 1; RET ]
		]

|| G R (Einfo noeval (Eidapl i [])) r n fl fs =
		Gseq [	pushvar i r n 0;
			Gi [ UPDATE 1; UNWIND ]
		]

|| G R (Eidapl i []) r n fl fs =
		Gseq [	pushvar i r n 0;
			if gnoargs i <= 0 then
				Gi [ EVAL ]
			else
				Gi [];
			Gi [ UPDATE 1; UNWIND ]
		]

#if 0
|| G R (Eidapl mi ([Eidapl i []])) r n fl fs & (id_ismethod mi) =
		Gseq [
		        pushvar i r n 0;
			Gi [ EVAL ];
   			Gi ( Gmethod (\n.\k.GETMETHOD k) 0 (id_metsel mi) );
			Gi [ EVAL ];			-- TEMP!
			Gi [ UPDATE 1; UNWIND ]
		]
			
|| G R (Eidapl mi el) r n fl fs & (id_ismethod mi)=
	let nel = length el - 1 in
	if na = nel then
		Gseq [	Gtail2 el r n;
			Gi ( Gmethod JMETHOD nel (id_metsel mi) )
		]
	else -- too many/few args supplied
		Gseq [	Gtail el r n;
			Gi [ EVAL ];
		        Gi ( Gmethod (\n.\k.GETMETHOD k) nel (id_metsel mi) );
			Gi [ EVAL ];			-- TEMP!
			Gi [ JFUN nel ]
		]
#endif

|| G R (Eidapl i el) r n fl fs & (~id_is_predef i) =
	let na = gnoargs i
	and nel = length el in
	if na = nel then
		Gseq [	Gtail2 el r n;
			Gi [ JGLOBAL nel i ]
		]
	else if na = -1 | na > nel then
		Gseq [	Gtail (Eidapl i [].el) r n;
			Gi [ JFUN nel ]
		]
	else -- too many args supplied
#if 0
		let d = nel-na in
		Gseq [	Gtail2 el r n;
			Gi [ ALLOC 1 ]; 
			Gi (rept (d+1) (PUSH (nel+1)));
			Gi [ PUSH (d+1) ];
			Gi (conc (rept d [ MKAP; PUSH 0; MOVE (nel+4) ]));
			Gi [ UPDATE 1; POP 1; MOVE (na+1) ];
			Gi [ JGLOBAL na i ]
		]
#else
		Gseq [	Gtail (Eidapl i [].el) r n;
			Gi [ JFUN nel ]
		]
#endif

|| G R (Einfo _ e) r n fl fs = G R e r n fl fs

|| G R e r n fl fs =
		Gseq [	G (E n) e r n fl fs;
			Gi [ UPDATE (n+1); POP n; UNWIND ]
		]
	
|| G (E s) (Eidapl (mkid Fseq _ _ _) [e1;e2]) r n fl fs =
		Gseq [  G (E s) e1 r n fl fs;
			Gi [ POP 1 ];
			G (E s) e2 r n fl fs
		]

|| G (E s) (e as Eidapl (mkid pn _ (idi_var (var_pre _) _) _) el) r n fl fs =
		Gseq [	G (B s) e r n Notalabel 0;
			Gi [ BCONSTR (prebasicconstr pn) ]
		]

|| G (E s) (Einfo noeval (Eidapl i [])) r n fl fs =
		pushvar i r n s

|| G (E s) (Eidapl i []) r n fl fs =
		Gseq [	pushvar i r n s;
			Gi [ EVAL ];
			updstack i r s
		]

#if 0
|| G (E s) (Eidapl mi [Eidapl i []]) r n fl fs & (id_ismethod mi) =
		Gseq [  pushvar i r n s;
			Gi [ EVAL ];
			Gi ( Gmethod (\n.\k.GETMETHOD k) 0 (id_metsel mi) );
			Gi [ EVAL ]			-- TEMP!
		]

|| G (E s) (Eidapl mi el) r n fl fs & (id_ismethod mi) =
	let nel = length el - 1 in
	if na = nel then
		Gseq [	Gi [ ALLOC 1 ];
			Gcpushrev el r (n+1);
			Gi ( Gmethod CALLMETHOD nel ks );
			Gslide (n-s)
		]
	else -- too many/few args supplied
		Gseq [	Gi [ ALLOC 1 ];
			Gcpushrev el r (n+1);
			Gi [ EVAL ];
		        Gi ( Gmethod (\n.\k.GETMETHOD k) nel (id_metsel mi) );
			Gi [ EVAL ];			-- TEMP!
			Gi [ CALLFUN nel ];
			Gslide (n-s)
		]
#endif

|| G (E s) (Eidapl i el) r n fl fs & (~id_is_predef i) =
	if gnoargs i = (length el) then
		Gseq [	Gi [ ALLOC 1 ];
			Gcpushrev el r (n+1);
			Gi [ CALLGLOBAL (length el) i ];
			Gslide (n-s)
		]
	else
		Gseq [	Gi [ ALLOC 1 ];
			Gcpushrev (Eidapl i [].el) r (n+1);
			Gi [ CALLFUN (length el) ];
			Gslide (n-s)
		]

|| G (E s) (Econstr c el) r n fl fs =
		G (C s) (Econstr c el) r n fl fs

|| G (E s) (Einfo _ e) r n fl fs = G (E s) e r n fl fs

|| G (J s ls) (e as Econstr c []) r n fl fs =
		case assocdef (cno c) ls (-1,Notalabel) in
		   (-1,Notalabel) : G (E s) e r n fl fs
		|| (k, l) : 
			Gseq[	Gpop (n-s);
				Gi [ JMP l ]
			]
		end
			
|| G (J s ls) e r n fl fs =
		G (E s) e r n fl fs

|| G (B s) (Eidapl (mkid Fcno _ _ _) [e1]) r n fl fs =
		Gseq [	G (E n)     e1 r  n    fl fs;
		        Gi [ GETTAG ];
			Gpop (n-s)
		     ]
|| G (B s) (Eidapl (mkid pn _ _ _) [e1;e2]) r n fl fs & (bigop pn) =
		Gseq [	G (E n)     e1 r  n    fl fs;
			G (E (n+1)) e2 r (n+1) fl fs;
			Gi [ BIGOP (prebasicop pn) ];
			Gpop (n-s)
		]

|| G (B s) (Eidapl (mkid pn ps (idi_var (var_pre _) _) _) el) r n fl fs =
		Gseq [	Gseq (map (\e.G (B n) e r n Notalabel 0) el);
			Gi [ BASICOP (prebasicop pn) ];
			Gpop (n-s)
		]

|| G (B s) (Econstr c []) r n fl fs =
		Gseq [	Gi [ PUSHBASIC (cno c) ];
			Gpop (n-s)
		]
		
|| G (B s) (Einfo noeval (Eidapl i [])) r n fl fs =
		Gseq [	pushvar i r n s;
			Gi [ GET ]
		]

|| G (B s) (Eidapl i []) r n fl fs =
		Gseq [	pushvar i r n s;
			Gi [ EVAL ];
			updstack i r s;
			Gi [ GET ]
		]

|| G (B s) (Einfo _ e) r n fl fs = G (B s) e r n fl fs

|| G (B s) e r n fl fs =
		Gseq [	Gi [ AMODE Astack ];
			G (E s) e r n fl fs;
			Gi [ AMODE Aheap; GET ]
		]

|| G (C s) (Einfo strict e) r n fl fs =
		-- switch to strict evaluation
		G (E s) e r n fl fs

|| G (C s) (Eidapl i []) r n fl fs =
		pushvar i r n s

|| G (C s) (e as Eidapl (mkid _ _ (idi_method ks na _) _) _) r n fl fs =
        fail ("Construct method call "@pr e)

|| G (C s) (Eidapl i el) r n fl fs & (~id_is_predef i) =
	let ar = gnoargs i in
	let lel = length el in
	if Stingy & ar = lel & ~ all Eisconst el then
                Gseq [  Gcpushrev el r n; 
                        Gi [ SCALLGLOBAL ar i ]
		     ]
        else
	if ar ~= -1 & ar ~= 0 & ar <= lel & ~NoVector then
		Gseq [	Gcpushrev (Eidapl i [].el) r n;
			Gi [ MKAPLV ar ];
			Gi (rept (lel - ar) MKAP);
			Gslide (n-s)
		]
	else
		Gseq [	Gcpushrev (Eidapl i [].el) r n;
			Gi (rept lel MKAP);
			Gslide (n-s)
		]

|| G (C s) (Econstr c el) r n fl fs =
		Gseq [	Gcpushrev el r n;
			Gi [ CONSTR (constrtype c) (cno c) (length el)];
			Gslide (n-s)
		]

|| G mode (Einfo _ e) r n fl fs = 
		G mode e r n fl fs
|| G _ e _ _ _ _ = fail ("Gcode "@pr e)
end
