module -- constrfun
-- selector functions for the Constr type.
#include "../misc/util.t"
#include "types.t.t"
#include "constr.t.t"
#include "id.t.t"
#include "id.t"
#include "ttype.t.t"
#include "ttype.t"
#include "../transform/hexpr.t"
export cname, ctype, ctinfo, cno, cargs, tctype, nconstrs,
	nth_constr, mkstring, isstring, constrtype, carity,
	mkfloat, mkinteger, isfloat, isinteger, mkrational, isrational;
rec
    cname  (Cconstr s _ _ _ _) = s
and ctype  (Cconstr _ t _ _ _) = t
and ctinfo (Cconstr _ _ i _ _) = i
and cno    (Cconstr _ _ _ n _) = n
and cargs  (Cconstr _ _ _ _ a) = a

and carity c = length (cargs c)

and tctype (mkconstr c _) = ctype c

and nconstrs (Cconstr _ _ (mktinfo _ n _ _ _) _ _) = n

-- make the nth constructor given type info.
and nth_constr n (ti as mktinfo t _ _ _ a) =
	let (mkcons i l) = select (n+1) a in
	Cconstr (idtostr i) t ti n l

and ITstring = mktinfo Tstring (-1) false false []
and mkstring s = Cconstr s Tstring ITstring (-1) []
and isstring (Cconstr _ _ (mktinfo _ (-1) _ _ _) _ _) = true
||  isstring _ = false
and mkfloat s = Cconstr s Tfloat (mktinfo Tfloat (-2) false false []) (-2) []
and isfloat (Cconstr _ _ (mktinfo t _ _ _ _) _ _) = eqtype t Tfloat
||  isfloat _ = false
and mkinteger s = Cconstr s Tinteger (mktinfo Tinteger (-3) false false []) (-3) []
and isinteger (Cconstr _ _ (mktinfo t _ _ _ _) _ _) = eqtype t Tinteger
||  isinteger _ = false
and mkrational s = Cconstr s Trational (mktinfo Trational (-4) false false []) (-4) []
and isrational (Cconstr _ _ (mktinfo t _ _ _ _) _ _) = eqtype t Trational
||  isrational _ = false
and constrtype (Cconstr s t _ no _) = 
        assocdefeq eqid (tname t) [(hiInt, Gint); (hiChar, Gchar); (hiFloat, Gfloat s); (hiInteger, Ginteger s)] 
	     (if no = -1 then
		Gstring s
	      else
	      	Gtype)
end
