
-- $Header: /ufs/usr.src/local/lml/src/expr/RCS/error.m,v 2.13 86/11/06 20:28:47 augustss Exp $
--
module -- errors
--
-- handle errors
--
#include "id.t.t"
#include "id.t"
#include "constr.t.t"
#include "ttype.t.t"
#include "ttype.t"
#include "einfo.t.t"
#include "types.t.t"
#include "pprint.t"
#include "impexp.t.t"
#include "../transform/misc.t"

export errors, merror, findloc;
rec
    merror e msg = mkerror (msg @ "\n" @ ppr e @ "\n")
and errors errtab t = map (findloc errtab " in definition of ") (ee t)
and
    ee (mkap e1 e2) = ee e1 @ ee e2
||  ee (mklam i e) = ee e
||  ee (mkcase e pbl) = ee e @ concmap ep pbl
||  ee (mkletv b e) = eb b @ ee e
||  ee (mkident i) = []
||  ee (mkconst c) = []
||  ee (mkmodule _ _ imp _ b) = eb b
||  ee (mkerror emsg) = [[emsg]]
||  ee (mkas _ e) = ee e
||  ee (mkcondp p c) = ee p @ ee c
||  ee (mklazyp p) = ee p
||  ee (mkconstr _ el) = concmap ee el
||  ee (mkfailmatch _) = []
||  ee (mkinfo t e) = ee e
||  ee (mklistg e qs) = ee e @ concmap eq qs
||  ee (mklistf _ es) = concmap ee es

and eq (mkqfilter e) = ee e
||  eq (mkqgen p e) = ee p @ ee e

and eb (mkbtype t ats _) = addnamei (tname t) (et t @ eats ats)
||  eb (mkbpat pbl) = addnamei (leftmostid (fst (hd pbl))) (concmap ep pbl)
||  eb (mkband b1 b2) = eb b1 @ eb b2
||  eb (mkbnull) = []
||  eb (mkblocal b1 b2) = eb b1 @ eb b2
||  eb (mkbrec b) = eb b
||  eb (mkbmulti p e) = ee p @ ee e
||  eb (mkberror emsg) = [[emsg]]
||  eb (mkbsyn t1 t2) = addnamei (tname t1) (et t1 @ et t2)
||  eb (mkbclass (c as mkcdecl aas a) b) = addnamei (clsname c) (concmap ea (a.aas) @ eb b)
||  eb (mkbinstance (mkidecl aas _ _ _) b _) = concmap ea aas @ eb b
||  eb (mkbdefault ts) = concmap et ts
||  eb (mkbsign is t) = et t

and ep (e, p) = ee e @ ee p

and et (mktcons _ ts) = concmap et ts
||  et (mktvar _) = []
||  et (mkterror emsg) = [[emsg]]
||  et (mktcontype aas t) = concmap ea aas @ et t

and ea (mkaerror emsg) = [[emsg]]
||  ea _ = []

and eats ats = (concmap eat ats
		where eat (mkcons _ tbs) = concmap (\(t,_).et t) tbs)

and eimp (mkimpid _ t _) = et t
||  eimp (mkimptype _ _ _) = []
||  eimp (mkimpeqtype _ ats _) = eats ats

and addnamei i l = map (\es.idtostr i.es) l

and findloc errtab _ [e] = fmt (fname errtab) 0 e
||  findloc errtab d ("Pmain".es) = findloc errtab d es
||  findloc errtab d (es as (f._)) =
    let (msg.ids) = reverse es in
    let msg = mix (msg.map drop_ ids) d in
    let (n, l) = assocdef f errtab (fname errtab, 0) in
    fmt n l msg
and fname ((_,(n,_))._) = n
||  fname _ = "???"	
and drop_ ('_'.s) = s
||  drop_ s = s
and fmt n l msg = "\""@n@"\", line "@itos l@", "@msg
end
