module C_Integral(Integral(..)) where
class  (Real a) => Integral a  where
    div, rem, mod	:: a -> a -> a
    divRem		:: a -> a -> (a,a)
    even, odd		:: a -> Bool
    toInteger		:: a -> Integer

    x `div` y		=  q  where (q,r) = divRem x y
    x `rem` y		=  r  where (q,r) = divRem x y
    x `mod` y 		=  if signum x == - (signum y) then r + y else r
			   where r = x `rem` y
    even x		=  x `rem` 2 == 0
    odd	x		=  x `rem` 2 /= 0

