module I_Double() where

import LML_Double

instance Real Double where
	toRational x	=  (m%1)*(b%1)^^n
			   where (m,n) = decodeFloat x
				 b     = floatRadix  x

instance  Floating Double  where
    pi			=  3.141592653589793238
    exp x		=  {-:"Dexp":-} x
    log x		=  {-:"Dlog":-} x
    sqrt x		=  {-:"Dsqrt":-} x
    sin x		=  {-:"Dsin":-} x
    cos x		=  {-:"Dcos":-} x
    tan x		=  {-:"Dtan":-} x
    asin x		=  {-:"Dasin":-} x
    acos x		=  {-:"Dacos":-} x
    atan x		=  {-:"Datan":-} x
    sinh x		=  {-:"Dsinh":-} x
    cosh x		=  {-:"Dcosh":-} x
    tanh x		=  {-:"Dtanh":-} x
--    asinh x		=  {-:"Dasinh":-} x
--    acosh x		=  {-:"Dacosh":-} x
--    atanh x		=  {-:"Datanh":-} x
#define log {-:"Dlog":-}
#define sqrt {-:"Dsqrt":-}
    asinh x = log (x + sqrt (1+x*x))
    acosh x = log (x + (x+1) * sqrt ((x-1)/(x+1)))
    atanh x = log ((x+1) * sqrt (1 - 1/(x*x)))
#undef log
#undef sqrt

instance  RealFrac Double where
	properFraction x   =  if n >= 0
			      then (m * b^n, 0)
			      else (m', fromInteger k / fromInteger d)
			   where (m,n)	= decodeFloat x
				 b	= floatRadix x
				 (m',k) = divRem m d
				 d	= b^(-n)
	approxRational x eps =
            case withinEps of
                r:r':_ | denominator r == denominator r' -> r'
                r:_				         -> r
            where withinEps = dropWhile (\r -> abs (fromRational r - x) > eps)
				(approximants p q)
	          (p,q)     = if n < 0 then (m, b^(-n)) else (m*b^n, 1)
         	  (m,n)     = decodeFloat x
	          b	    = toInteger (floatRadix x)

instance  RealFloat Double where
	floatRadix _	= 2
	floatDigits _	= 53
	floatRange _	= (-1021, 1024)
	decodeFloat x 	= {-:"Ddecode":-} x
	encodeFloat x y	= {-:"Dencode":-} x y

instance  Ix Double where
	range (x,y) = [x..y]
	index (x,y) i = floor (i - x)
	inRange (x,y) i = x <= i && i <= y

instance  Enum Double where
	enumFrom x = enumFromBy x 1.0
	enumFromThen x y = enumFromBy x (y - x)

enumFromBy n k		=  n : enumFromBy (n+k) k

