--
-- Instances for Int (32 bit builtin arithmetic) operations
-- 
module I_Int() where
instance Ix Int where
	range (l,h) = irange l h
	index (l,h) x = x - l
	inRange (l,h) x = l <= x && x <= h

irange :: Int->Int->[Int]
irange l h = if l > h then [] else l : irange (l+1) h


instance Enum Int where
	enumFrom n = from n
	enumFromThen n m = fromi n (m - n)
	enumFromTo n m = if m > n then irange n m else irrange n m
	enumFromThenTo n m p = if m > n then iranges n (m-n) p else irranges n (m-n) p

from :: Int -> [Int]
from n = n : from (n+1)
fromi :: Int -> Int -> [Int]
fromi n i = n : fromi (n+i) i
irrange :: Int->Int->[Int]
irrange l h = if l < h then [] else l : irange (l-1) h
iranges :: Int->Int->Int->[Int]
iranges l i h = if l > h then [] else l : irange (l+i) h
irranges :: Int->Int->Int->[Int]
irranges l i h = if l < h then [] else l : irange (l+i) h

