module
#include "mcodedef.t.t"
#include "../Gcode/Gcodedef.t.t"
#include "Wuse.t"
#include "mutil.t"
#include "mutil1.t"
#include "mregs.t"
#include "mstrlbl.t"
#include "mstrid.t"
#include "handmade.mcode.t"
#include "../misc/flags.t"

export mbconstrupdate, mcpairupdate, mctagupdate, mcnilupdate;

mbconstrupdate t g G bc m aV S =
	let (a.V) = aV in -- must be lazy
	let bcs = strbc bc in
	let (c, d, uv, us, k) = M t g G V S
	and (bco, br) = intoareg (indS (m-1) S) aV S
	in (	Mcom ("BCONSTR "@bcs) . Mcom ("UPDATE "@itos m).
		bco @ 
		(if Parallel then Mmove mupdtag (regind br 0) else Mcom "").
		Mmove a           (regind br 1).
		Mmove (idlit bcs) (regind br 0).
		c,
			d, Wuse.uv, us, k)
and

mcpairupdate t g G is n V abS =
	let (a.b.S) = abS in -- must be lazy
	let (c, d, uv, us, k) = M t g G V S
	and (bco, br) = intoareg (indS (n-1) S) V abS
	in (	Mcom ("CPAIR"). Mcom("UPDATE "@itos n).
		bco @
		(if Parallel then Mmove mupdtag (regind br 0) else Mcom "").
		Mmove a  (regind br 1).
		Mmove b  (regind br 2).
		Mmove is (regind br 0).
		c,
			d, uv, Wuse.Wuse.us, k)
and

mcnilupdate t g G m n V S =
	let (c, d, uv, us, k) = M t g G V S
	and (bco, br) = intoareg (indS (n-1) S) V S
	in (	Mcom ("CNIL "@itos m). Mcom("UPDATE "@itos n).
		bco @
		(if Parallel then Mmove mupdtag (regind br 0) else Mcom "").
		Mmove (const m) (regind br 1).
		Mmove mniltag   (regind br 0).
		c,
			d, uv, us, k)

and
mctagupdate t g G m n V aS =
	let (a.S) = aS in
	let (c, d, uv, us, k) = M t g G V S
	and (bco, br) = intoareg (indS (n-1) S) V aS
	in (	Mcom ("CTAG "@itos m). Mcom("UPDATE "@itos n).
		bco @
		(if Parallel then Mmove mupdtag (regind br 0) else Mcom "").
		Mmove (const m) (regind br 1).
		Mmove a         (regind br 2).
		Mmove mtagtag   (regind br 0).
		c,
			d, uv, Wuse.us, k)
end
