module -- import
-- $Header: /ufs/usr.src/local/lml/src/rename/RCS/import.m,v 97.0 90/07/07 14:41:45 augustss Exp $
--
#include "../expr/impexp.t"
#include "../expr/types.t.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../misc/misc.t"
#include "../misc/flags.t"
#include "renenv.t"
#include "importpre.t"
#include "importlib.t"
#include "himport.t"
#include "renameutil.t"
#include <Option>
export importenv, preenv, himportenv, badmodname, startu;
rec
    (preenv, startu) = 
    let rec (pree, u) = 
        let (envs, u) = Umap (genimpenv (rperm pree)) (preimp.implib) 1000 	-- This is where the unique numbers start
        in (reduce rjoin rnil envs, u)
    in (addmets pree, u)

and importenv u imps =
        let rec (menvs, u1) = Umap (genimpenv xenv) imps u
	and      xenv = rperm (reduce rjoin preenv menvs) in
	if ImpDebug then
	    if Test then
		trace (show_Renv xenv) (u1, xenv, [])
	    else
		trace (show_list show_Renv menvs) (u1, xenv, [])
	else
	    (u1, xenv, [])

and preludename = "_Prelude"
and badmodname id = ~AllowRedef & head (length preludename) (idtostr id) = preludename
-- Handle import of Prelude
and himportenv u imps =
    case partition (\(mkimport id _ _ _ _ _ _).idtostr id = preludename) imps in
	([], _) : importenv u imps
    ||  ([p], ns) :
	     -- We have to filter the environment coming from importenv
	     let (u', env, nimps) = importenv u ns in
	     (u', flt p env, nimps)
    ||  (_,_) : fail "Sorry!  Multiple imports of Prelude not implmented yet.\n"
    end

-- filter the environment according to the spec
and flt (mkimport _ _ _ _ show fltr rens) env =
--trace ("flt "@show_bool show@" "@show_list (prid o expid) fltr@show_list (show_pair(prid,prid)) rens) (
    -- This is not really right, importing should work like in getimport, but I'm fed up with this!
    let ifltr = map (idtostr o expid) fltr in
    let srens = map (\(x,y).(idtostr x, idtostr y)) rens in
    let r = rmapfilter Ktype ff (rmapfilter Kvalue ff env)
    where ff (mkid n s i (on as Orignames v f (m._))) & (m = preludename) =
	if (if show then mem s ifltr else ~ mem s ifltr) then
	    -- Keep it
	    Some (mkid n (assocdef s srens s) i on)
	else
	    None
    ||	  ff i = Some i
--)
    in if null rens then r else rrehash r
end
