module -- renametype
--
-- $Header: /ufs/usr.src/local/lml/src/rename/RCS/renametype.m,v 97.0 90/07/07 14:41:55 augustss Exp $
--
-- do type renaming
--
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t.t"
#include "../expr/einfo.t.t"
#include "../expr/types.t.t"
#include "../expr/ttype.t"
#include "../expr/id.t"
#include "../misc/misc.t"
#include "../misc/util.t"
#include "../misc/flags.t"
#include "renameutil.t"
#include "renenv.t"
/*#include "deriv.t"*/
#include <Option>

export rentype, renbtype, renbt, renbtenv, rensyntype, rencontext, syncirc;
rec
    rentype env tt =
	case tt in
	    mktcons (i as mkids s) ltt :
	        case rfind Ktype s env in
		    mkid 0 _ _ _ :  
			if Curry then
			    mkterror ("Undefined type "@oprid i)
			else
			    mktcons (mkid 0 s idi_udef noorigname) (map (rentype env) ltt)
		|| (id as (mkid _ _ (idi_type _ n _ _ _) _)) :
			if length ltt = n then
		            mktcons id (map (rentype env) ltt)
			else
			    mkterror ("Bad type arity "@oprid i)
		|| (id as (mkid _ _ (idi_syn src n dst) _)) :
			if length ltt = n then
			    mktcons id (map (rentype env) ltt)
			else
			    mkterror ("Bad type synonym arity "@oprid i)
		|| _ : mkterror ("Not a type "@oprid i)
		end
	|| mktcons (mkid _ _ _ _) _ : tt		-- already renamed
	|| mktvar _ : tt
	|| mktcontype ts t : mktcontype (map (rencontext env) ts) (rentype env t)
	|| mkterror _ : tt
	end
and rencontext env tt =
	case tt in
	    mkassert (i as mkids s) v :
	        case rfind Ktype s env in
		    mkid 0 _ _ _ :  
			    mkaerror ("Undefined class "@oprid i)
		|| (id as (mkid _ _ (idi_class _) _)) :
		            mkassert id v
		|| _ : mkaerror ("Not a class "@oprid i)
		end
        || mkassert (mkid _ _ _ _) _ : tt
	end
and renbt ff env u tt atl =
        let (mktcons _ vs) = tpart tt in
	if difference (reduce (union o getTvars) [] (concmap (\(mkcons _ tbs).map fst tbs) atl)) (getTvars tt) ~= [] | anysame vs then
	    (u, mkterror "Bad type var", [])
	else
	let ttn = rentype env tt in
	let rec atln = map2 (\n.\(mkcons i ts).
	    let tsn = mapfst (rentype env) ts in
	    let s = idtostr i in
            let rec ii = (mkid (u+n) s (idi_constr ttn tsn n atln) (ff ii)) in
	    (mkcons ii tsn))
		        (from 0) atl
	in (u+length atl, ttn, atln)

and renbtenv atln = (rlist Kvalue (concmap rene atln)
		where rene (mkcons (i as mkid no s ii on) _) = [i]
		   || rene _ = [])

and isflat ats = all (\(mkcons _ xs).length xs = 0) ats

-- Deriving info is handled later when all is known
and renbtype ff env0 u (mkbtype ott atl ds) =
    case tpart ott in
	(mktcons (mkids s) tts) : 
	let rec tenv = rone Ktype iii
        and      iii = mkid u s (idi_type ttn (length tts) ti [] dsx) (ff iii)
        and       ti = mktinfo ttn (length atln) false (isflat atln) atln
	and      env = rjoin tenv env0
	and      (u1, ttn, atln) = renbt ff env (u+1) ott atl
        and      dsx = oapply (map (\i.rfind Ktype (idtostr i) env0)) ds 
        and       nc = filter (not o id_isclass) (gsome dsx)
        and       b' = mkbtype ttn atln dsx in
	(u1, (if null nc then b' else mkberror ("Non-classes in deriving: "@mixmap oprid nc ", ")), rjoin tenv (renbtenv atln))
    end

and rensyntype ff env0 u (mkbsyn src dst) =
    let (tsrc as mktcons (mkids s) vs) = tpart src in
    let rec tenv = rone Ktype iii
    and      iii = mkid u s (idi_syn src' (length (getTvars tsrc)) dst') (ff iii)
    and     src' = rentype (rjoin tenv env0) src
    and     dst' = rentype env0 dst in
    let msg = prttype src in
    let b = 
	if difference (getTvars dst) (getTvars tsrc) ~= [] | anysame vs then
	    mkberror ("Synonym has bad type var: "@msg)
	else
	    case dst in
		mktcons _ _ : mkbsyn src' dst'
	    ||  _ : mkberror ("Bad synonym definition: "@msg)
	    end
    in (u+1, b, tenv)

-- Check that the environment contains no circular type synonyms.
and syncirc env =
    let is = filter id_issyn (rids Ktype env) in
    let g = map (\(i as mkid _ _ (idi_syn _ _ dst) _).(i, filter id_issyn (gettids dst))) is in
    false & hascycleeq eqid g
and gettids (mktcontype _ t) = gettids t
||  gettids t = Typerec (\v.[]) (\i.\iss. i.conc iss) t
end
