module -- renenv
-- Handle environment for renaming.
#include "../misc/misc.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#define TEMP (List Id)
#define PERM (List TEMP)
#define HASH 11
export rnil, rone, rjoin, rjoin1, rlist, rfind, rids, rperm, Kind, show_Renv, rstrs, rmapfilter, rrehash;
rec type Renv = renv TEMP PERM TEMP PERM TEMP PERM
and type Kind = Kvalue + Ktype + Kmodule + Kall

and np = rept HASH []
-- Hash string (and make it fast!)
-- skip first char since its mostly the same.
and hash [] = 0			-- Should never occur
||  hash [c1] = ord c1 % HASH
||  hash [c1;c2] = ord c2 % HASH
||  hash [c1;c2;c3] = (ord c2 + ord c3) % HASH
||  hash (c1.c2.c3.c4._) = (ord c2 + ord c3 + ord c4) % HASH
and rnil = renv [] np [] np [] np
and rone k i = rinj k [i]
and rinj k e =
	case k in
	    Kvalue : renv e np [] np [] np
	||  Ktype  : renv [] np e np [] np
	||  Kmodule: renv [] np [] np e np
	end
and rsel Kvalue (renv e _ _ _ _ _) = e
||  rsel Ktype  (renv _ _ e _ _ _) = e
||  rsel Kmodule(renv _ _ _ _ e _) = e
and rselp Kvalue (renv _ e _ _ _ _) = e
||  rselp Ktype  (renv _ _ _ e _ _) = e
||  rselp Kmodule(renv _ _ _ _ _ e) = e
and rjoin (renv [] _ [] _ [] _) r = r
||  rjoin (renv av _ at _ am _) (renv bv pv bt pt bm pm) = renv (av@bv) pv (at@bt) pt (am@bm) pm
and rjoin1 (renv v pv t pt m pm) Kvalue  i = renv (i.v) pv t pt m pm
||  rjoin1 (renv v pv t pt m pm) Ktype   i = renv v pv (i.t) pt m pm
||  rjoin1 (renv v pv t pt m pm) Kmodule i = renv v pv t pt (i.m) pm
and rlist k r = rinj k r
and undefid = dummyid
and rfind Kall s (renv v _ t _ m _) = lookfor s (v@t@m) undefid
--||  rfind k s r = lookfor s (rsel k r) (lookfor s (select (hash s + 1) (rselp k r)) undefid)
||  rfind k s r = 
-- this should be faster since we don't build the second call to lookfor.
-- A lot of time is spent here in rename, so it is maybe worth it.
-- (The use of mkids "" to detect a non-hit is not accidental, using dummyid and checking if the
-- found id-no is 0 causes a (rare) data-dependency loop!)
    case lookfor s (rsel k r) (mkids "") in
	mkids "" : lookfor s (select (hash s + 1) (rselp k r)) undefid
    ||  i : i
    end
and lookfor s [] d = d
||  lookfor s ((i as mkid _ s1 _ _).is) d = if s=s1 then i else lookfor s is d
and rstrs Kall (renv v _ t _ m _) = map idtostr (v@t@m)
||  rstrs k r = map idtostr (rsel k r)
and rids Kall (renv v ov t ot m om) = conc (conc [v.ov; t.ot; m.om])
||  rids k r = conc (rsel k r.rselp k r)
and rperm (renv v ov t ot m om) = renv [] (hashl v ov) [] (hashl t ot) [] (hashl m om)
and hashl is old = reduce (\(d as (mkid _ s _ _)).\ps. adde (hash s) ps d) old is
and adde 0 (x.xs) d = (d.x).xs
||  adde n (x.xs) d = x.adde (n-1) xs d
and show_Renv (renv x xs y ys z zs) = "Values: "@show_list prid (conc (x.xs))@"\nTypes: "@show_list prid (conc (y.ys))@"\nModules: "@show_list prid (conc (z.zs))@"\n"
and rmapfilter Kvalue f (renv v vs t ts m ms) = renv (mapfilter f v) (map (mapfilter f) vs) t ts m ms
||  rmapfilter Ktype  f (renv v vs t ts m ms) = renv v vs (mapfilter f t) (map (mapfilter f) ts) m ms
-- This is a hack to allow rmapfilter to change the name of the id.
and rrehash (renv v vs t ts m ms) = renv [] (hashl (conc (v.vs)) np) [] (hashl (conc (t.ts)) np) [] (hashl (conc (m.ms)) np)
end
