#include <parallel/parallel.h>
#include <parallel/microtask.h>

slock_t l_gc, l_chunk;

init()
{
    s_init_lock(&l_gc);
    s_init_lock(&l_chunk);
}

fini()
{
    m_kill_procs();
}

dogc()
{
    /* Wait for all processors to start the GC. */
    m_single();
    /* Swap the spaces, setup gc_hp ... */
    ...
    m_multi();

    /* Obtain the GC lock */
    s_lock(&l_gc);
    /* Do per processor GC, update gc_hp */
    ...
    /* Update local hp, and hpend */
    ...
    s_unlock(&l_gc);

    m_single();
    /* Finish up after GC */
    ...
    wantgc = 0;		/* Gc not needed any more */
    m_multi();
}

int **
newchunk()
{
    /* Obtain exclusive access to heap pointer */
    s_lock(&l_chunk);
    if (ch_hp > ch_hp_max) {
	/* Maximum exceeded, must do GC */
	s_unlock(&l_chunk);
	wantgc++;	/* Signal that GC is needed */
	dogc();
	s_lock(&l_chunk);
    }
    p = ch_hp;
    ch_hp += CHUNKSIZE;
    s_unlock(&l_chunk);
    return p;
}
