module
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/constrfun.t"
#include "../Expr/Expr.t.t"
#include "../expr/einfo.t.t"
#include "../expr/id.t"
#include "../expr/impexp.t.t"
#include "../misc/setofid.t"
#include "../misc/misc.t"
#include "../misc/flags.t"
#include "../funnos.h"
#include "../Expr/Eprint.t"
#include "../transform/hexpr.t"

export strictanal;
rec
    thd (_,_,x) = x
and impinfo (i, _, f) = (id_no i,f)
and isfail (Efailmatch 0) = true
||  isfail (Eidapl i _) & (isidfail i) = true
||  isfail _ = false
and Isl [] = []
||  Isl (a.b) = reduce Is a b
and iscanon (Einfo strict _) = true
||  iscanon (Einfo noeval _) = true
||  iscanon (Econstr _ _) = true
||  iscanon _ = false
and not0 (Econstr c _) = cno c ~= 0
||  not0 _ = false
and islamapl (Elamapl _ _ []) = true
||  islamapl _ = false
and mkstrict (e as Einfo strict _) = e
||  mkstrict e = Einfo strict e
and strictvar a e = (svar e
    where rec
    svar (Ecase e cies ed) =
    	if isfail ed then
	    Iu (svar e) (Isl (map (svar o thd) cies))
	else
	    Iu (svar e) (Is (svar ed) (Isl (map (svar o thd) cies)))
||  svar (Elet r ies e) =
	let s = svar e in
	if r then s
	else reduce (\(i,e).\r.if Imem i s then Iu (svar e) r else r) s ies
||  svar (Eidapl i []) = [i]
||  svar (Eidapl i es) =
	case idinfo a i in
	    f_unk : []
	||  finfo n ss _ _ :
		if length es < n then []
		else reduce (\(s,e).\r.if s then Iu (svar e) r else r) []
			    (combine (ss, head n es))
	end
||  svar _ = [])

and idinfo a (mkid _ _ (idi_var (var_global f) _) (Orignames Vimported _ _)) = f
||  idinfo a (mkid m _ (idi_var (var_pre f) _) _) = f
||  idinfo a (mkid m _ _ _) = assocdef m a f_unk

and sanal a sis vs e = (sa a vs e
where rec
    sa a vs (Ecase e cies ed) =
	let (vs1, ne) = sa a vs e in
	let vsn = Iu vs1 vs in
	let (vss, nes) = split (map (sa a vsn o thd) cies)
	and (vsd, ned) = sa a vsn ed in
	let vs2 = if isfail ed then Isl vss else Is vsd (Isl vss)
	and ncies = map2 (\(c,is,_).\e.(c,is,e)) cies nes in
	(Iu vs1 vs2, Ecase ne ncies ned)
||  sa a vs (Elet r ies e) = 
	let (fs, ds) = partition (islamapl o snd) ies in
	let (a1, nfs) = split (map f fs)
	where f (i, Elamapl is e []) =
		let (f, ne) = si a vs is e in
		((id_no i, f), (i, Elamapl is ne []))
	in
	let (nvss, nds) = split (map f ds)
	where f (i,e) =
		let (nvs, ne) = sa a vs e in
		if r then
			([], (i, ne))
		else if Imem i sis then
			(Iu [i] nvs, (i, mkstrict ne))
		else
			((if iscanon ne then [i] else []), (i, ne))
	in
	let vs1 = reduce Iu [] nvss in
	let (vs2, ne) = sa (a1@a) (Iu vs1 vs) e in
	(Iu vs1 vs2, Elet r (nfs@nds) ne)
||  sa a vs (Eidapl i []) =
	if EvalOpt & Imem i vs then ([], Einfo noeval (Eidapl i []))
	else ([i], Eidapl i [])
-- A hack to handle left-to-right behaviour of dyadic predefined functions
||  sa a vs (Eidapl i [e1;e2]) & (id_is_predef i) =
        let m = id_no i in
	let (nvs1, ne1) = sa a vs e1 in
	let (nvs2, ne2) = sa a (Iu nvs1 vs) e2 in
	if iscanon ne1 & iscanon ne2 & (m ~= Fdiv & m ~= Fmod | not0 ne2) then
		(Iu nvs2 (Iu nvs1 vs), mkstrict (Eidapl i [ne1; ne2]))
	else
		(Iu nvs2 (Iu nvs1 vs), Eidapl i [ne1; ne2])
||  sa a vs (Eidapl i es) =
	case idinfo a i in
	    f_unk : 
		let e = Eidapl i (map (snd o sa a vs) es) in
		([], e)
	||  finfo n ss s _ :
		if length es < n then
			([], Eidapl i (map (snd o sa a vs) es))
		else
			let (nvss, nes) = split (map (sa a vs) es) in
			let xx = reduce (\(s,is).\r.if s then Iu is r else r)
					[] (combine (ss, head n nvss)) in
			if s & all iscanon nes then
				(xx, mkstrict (Eidapl i nes))
			else
				(xx, Eidapl i nes)
	end
||  sa a vs (Econstr c es) =
	([], Econstr c (map (snd o sa a vs) es))
||  sa a vs (Elamapl is e es) =
	([], Elamapl is (snd (sa a vs e)) (map (snd o sa a vs) es))
||  sa _ _ (Efailmatch n) = ([], Efailmatch n)
||  sa a vs (Einfo i e) = let (vs, e1) = sa a vs e in (vs, Einfo i e1)
||  sa _ _ _ = fail "sa"
)

and si a vs is e = 
	let sis = strictvar a e in
	(finfo (length is) (map (\x.Imem x sis) is) false (-1),
	 snd (sanal a sis vs e))

and tr a (i, (Elamapl is e [])) =
	let (f, en) = si a [] is e
	in ((id_no i,f).a, (i, Elamapl is en []))
||  tr a (i, e) = 
	let (f, en) = si a [] [] e
	in ((id_no i,f).a, (i, en))

and strictanal (Emodule i es bs) =
	let (an, nbs) = mapstate (mapstate tr) [] bs in
	let f (mkexpid (i as mkid n s (idi_var _ t) on)) & (id_visibility i ~= Vimported) =
	         mkexpid (mkid n s (idi_var (var_global (assocdef n an f_unk)) t) on)
	 || f i = i in
	Emodule i (map f es) nbs
end
