module -- hexpr
-- Useful expressions
#include "../misc/flags.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/constr.t.t"
#include "../rename/renenv.t"
#include "../rename/import.t"
#include "cutil.t"

-- There is a serious problem with these identifers: they have not
-- been through the final renaming phase that adds the class and instance
-- info.  BEWARE!!

export hiand, hiadd, hisub, hige, hieq, hctrue, hcfalse,
       hilt, hile, hior, hileint, --hilte, hieqe, hilee,
       hiEq, hiOrd, hiIx, hiEnum, hiText, hiBinary, 
       hiARROW, hicno, hifail, hieqint, hiord, hiltint,
       hirange, hiindex, hiinRange, hishowsPrec, hireadsPrec,
       hishowString, hishowParen, hishowChar, hicomp,
       hiPrange, hiPindex, hiPinRange, hinever,
       hienumFrom, hienumFromThen, hienumFromTo, hienumFromThenTo,
       hienumFT, hienumFTT, --hienumTF, hienumTFT,
       hireadBin, hishowBin, hiPreadBin, hiPshowBin,
       hitrue, hifalse, hicons, hinil, hiDialogue,
       hifromInteger, hifromRational, hirangeSize,
       hipair, hcpair, himul, hiList, hiInt, hiChar, hiBool, hiFloat, hiInteger,
       hcnil, hccons, higt, hine, hinegate, hi_ord, hi_chr, hiseq, hidiv, himod,
       hiDouble, stdClass, numClass, hiNum, hiRational,
       hinot, hiotherwise, hiString, hiIntegral,
       hiconc, hireadParen, hilex,
       hituple, isidfail;

rec vf s = rfind Kvalue s preenv
and vt s = rfind Ktype s preenv
and vfc s1 s2 = if Curry then vf s1 else vf s2
and vtc s1 s2 = if Curry then vt s1 else vt s2
and hiand      = vf "_&&"
and hior       = vf "_||"
and hinot      = vf "_not"
and hiotherwise= vf "_otherwise"
and hiadd      = vf "_+"
and himul      = vf "_*"
and hisub      = vf "_-"
and hidiv      = vfc "_div" "_/"
and himod      = vfc "_mod" "_%"
and hinegate   = vf "_negate"
and hi_ord     = vf "_ord"
and hi_chr     = vf "_chr"
and higt       = vf "_>"
and hige       = vf "_>="
and hilt       = vf "_<"
and hile       = vf "_<="
and hieq       = vfc "_==" "_="
and hine       = vfc "_/=" "_~="
and hicomp     = vfc "_." "_o"
and hirange    = vf "_range"
and hiindex    = vf "_index"
and hiinRange  = vf "_inRange"
and hienumFrom = vf "_enumFrom"
and hienumFromThen = vf "_enumFromThen"
and hienumFromTo   = vf "_enumFromTo"
and hienumFromThenTo = vf "_enumFromThenTo"
and hireadBin  = vf "_readBin"
and hishowBin  = vf "_showBin"
and hishowsPrec= vf "_showsPrec"
and hireadsPrec= vf "_readsPrec"
and hishowString = vf "_showString"
and hishowParen = vf "_showParen"
and hishowChar = vf "_showChar"
and hifromInteger = vf "_fromInteger"
and hifromRational = vf "_fromRational"
and hirangeSize = vf "_rangeSize"
and hicno      = vf "Pcno"
and hifail     = vf "Pfail"
and hieqint    = vf "Peqi"
and hiltint    = vf "Plti"
and hileint    = vf "Plei"
--and hieqe      = vf "Peqe"
--and hilte      = vf "Plte"
--and hilee      = vf "Plee"
and hiord      = vf "Pord"
and hiPrange   = vf "Prange"
and hiPindex   = vf "Pindex"
and hiPinRange = vf "PinRange"
--and hienumTF   = vf "PenumTF"
--and hienumTFT  = vf "PenumTFT"
and hienumFT   = vf "PenumFT"
and hienumFTT  = vf "PenumFTT"
and hiPreadBin = vf "PreadBin"
and hiPshowBin = vf "PshowBin"
and hinever    = vf "Pnever"
and hiseq      = vf "Pseq"
and hitrue     = vfc "_True" "_true"
and hifalse    = vfc "_False" "_false"
and hicons     = vfc "_:" "_."
and hinil      = vf "_[]"
and hipair     = vf "P#2"
and hiconc     = vf "_++"
and hireadParen= vf "_readParen"
and hilex      = vf "_lex"
and hctrue     = idtoconstr hitrue
and hcfalse    = idtoconstr hifalse
and hcpair     = idtoconstr hipair
and hcnil      = idtoconstr hinil
and hccons     = idtoconstr hicons
and hiEq       = vt "_Eq"
and hiOrd      = vt "_Ord"
and hiIx       = vt "_Ix"
and hiEnum     = vt "_Enum"
and hiText     = vt "_Text"
and hiBinary   = vt "_Binary"
and hiARROW    = vt "P->"
and hiDialogue = vt "_Dialogue"
and hiString   = vt "_String"
and hiList     = vtc "PList" "_List"
and hiInt      = vt "_Int"
and hiInteger  = vt "_Integer"
and hiRational = vt "_Rational"
and hiFloat    = vt "_Float"
and hiChar     = vt "_Char"
and hiBool     = vt "_Bool"
and hiDouble   = vt "_Double"
and hiNum      = vt "_Num"
and hiReal     = vt "_Real"
and hiFractional = vt "_Fractional"
and hiIntegral = vt "_Integral"
and hiRealFrac = vt "_RealFrac"
and hiFloating = vt "_Floating"
and hiRealFloat= vt "_RealFloat"
and hituple n  = vt ('_'.'#'.itos n)

and stdClass   = [hiEq; hiText; hiBinary; hiOrd; hiIx; hiEnum]
and numClass   = [hiNum; hiReal; hiFractional; hiIntegral; hiRealFrac; hiFloating; hiRealFloat]

and isidfail i = eqid i hifail

end
