--
-- $Header: /ufs/usr.src/local/lml/src/type/RCS/tchk.m,v 97.0 90/07/07 14:42:45 augustss Exp $
--
module -- tchk
--
-- typechecker
--
#include "../expr/ttype.t.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/ttype.t"
#include "../expr/impexp.t.t"
#include "../expr/error.t"
#include "../Expr/Expr.t.t"
#include "../Expr/Eprint.t"
#include "../transform/misc.t"
#include "../misc/flags.t"
#include "../misc/misc.t"
#include "../rename/importpre.t"
#include "subst.t.t"
#include "check.t"
#include "hcheck.t"
#include "prefix.t"
#include "unify.t"
#include "subst.t"
#include <OK>

export tcheck;

rec
    normt ot =
        let t = normtype ot in
	Ohastype t (getTvars t)

and Wdlx p b defs u = if Curry then Wdlh p b defs u else Wdll p b u

and tcheck errmap (e0 as Emodule mid exps b) defs u0 = 
    let u = u0+1 in
     if ~TypeCheck then
	([], emptyTR, e0, startpre, u)
     else
	let! (S, npre, u', b') = Wdlx startpre b defs u in
	case S in
	   (bad s) : ([findloc errmap " in " s], emptyTR, e0, npre, u')
        || _ :
	-- check if main program
	    case exps in
	       [mkexpid (i as mkid n "Pmain" (idi_var vi _) on)] :
		let! (ty, _) = pfind i npre in
		let U = Unify ty (Tarr Tstring (if nuflag then Tlist Tchar else mktvar u0)) in
		case U in
		   (bad s) : ([findloc errmap " in " s], emptyTR, e0, npre, u')
		|| _ : let t = normt (TRtype U ty) in 
		       ([], pruneTR u S, Emodule mid [mkexpid (mkid n "Pmain" (idi_var vi t) on)] b', npre, u')
		end
	    || _ :
		case ynsplit (map (addexptype npre) exps) [] [] in
		    (nexps, []) : ([], pruneTR u S, (Emodule mid nexps b'), npre, u')
		||  (nexps, nos) : ([findloc errmap " in " ["Bad overloading in exports: "@mixmap oprid nos ", "]], emptyTR, e0, npre, u')
		end
	    end
	end

and addexptype npre (mkexpid (i as mkid n s (idi_var vi _) on)) =
    let (t, vs) = pfind i npre in
    if difference (getTvars t) vs = [] | Relax then
	Yes (mkexpid (mkid n s (idi_var vi (normt t)) on))
    else
	No i
||  addexptype _ e = Yes e					
end
