--
-- $Header: /ufs/usr.src/local/lml/src/type/RCS/unify.m,v 97.0 90/07/07 14:42:46 augustss Exp $
--
module -- unify
--
-- unification algorithm
--
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../misc/flags.t"
#include "subst.t.t"
#include "subst.t"
#include "conutil.t"

export Unify, badu;

rec
-- prune shouldn't look inside the substitution, but rather use some function
-- in subst.m!
    prune (mktvar n) (S as ok _ s) =
		case assocdef n s (mktvar 0) in
		   mktvar 0 : mktvar n
		|| v : prune v S
		end
 || prune N _ = N

and occursb v (mktvar m) _ = v = m
 || occursb v (mktcontype ts t) s = occursb v t s | exists (occursa v s) ts
 || occursb v (mktcons _ l) s = occursl v l s
and occursl v [] _ = false
 || occursl v (a.b) s = occursb v (prune a s) s | occursl v b s
and occursa v s (mkassert _ vv) = occursb v (prune (mktvar v) s) s

and badu s a b = bad [s @ "\n    " @ prttype a @ "\nand " @ prttype b @ "\n"]

and Unify M N = 
    -- take out context first for speed.
    case M in
	mktcontype kM M' :
	    case N in
		mktcontype kN N' : addconTR (combcon kM kN) (unify0 M' N' emptyTR)
	    ||  _ : addconTR kM (unify0 M' N emptyTR)
	    end
    || _ :
	    case N in
		mktcontype kN N' : addconTR kN (unify0 M N' emptyTR)
	    ||  _ : unify0 M N emptyTR
	    end
    end

    where rec
    unify0 N0 M0 s = unify1 N0 M0 s		-- N0, M0 used in error reporting (this may cost some time!)
    where rec
    unify1 N1 M1 s =
	let N = prune N1 s in
	let M = prune M1 s in
	case N in
	   mktvar n :
		case M in
		   mktvar m : if n = m then s else
				  if n > m then addTR (n, M) s
				           else addTR (m, N) s
		|| mktcons c l : if occursb n M s then
					badu "unify1 (occurence)" N0 M0
				   else
					addTR (n, M) s
		|| _ : fail ("unify1 "@prttype N@" -- "@prttype M)
		end
	|| mktcons cn ln :
		case M in
		   mktvar m : if occursb m N s then
				  badu "unify2 (occurence)" N0 M0
			      else
				  addTR (m, N) s
		|| mktcons cm lm :
			if teqid cn cm then
				unifyl ln lm s
			else
				-- No cause for alarm yet, one (or both) of the ids may be type synonyms.
				-- Check for this and expand synonyms.
				if id_issyn cm then
				    unify1 (synexpand M) N s
				else if id_issyn cn then
				    unify1 M (synexpand N) s
				else
				    badu "Cannot unify types:" N0 M0
		|| _ : fail ("unify1 "@prttype N@" -- "@prttype M)
		end
	|| _ : fail ("unify1 "@prttype N@" -- "@prttype M)
	end

and unifyl [] [] s = s
 || unifyl (h1.t1) (h2.t2) s = unifyl t1 t2 (unify0 h1 h2 s)
 || unifyl _ _ _ = bad ["unify arity"]

-- ** LML hack
-- Special eqid test for types.  Since undeclared types are allowed, there may be types that are udef (id = 0)
-- in the prelude.  Allow these to compare equal to another if the strings are equal.
-- ** Haskell Prelude hack
-- Also allow different numbers if we are allowing redefinitions
and teqid (mkid n1 s1 _ _) (mkid n2 s2 _ _) = n1 = n2 & n1 ~= 0 | (n1 = 0 | n2 = 0 | AllowRedef) & s1 = s2

end
