/*	mcread: mbinary.c
	Copyright (C) 1991, Mike Gleason Jr & NCEMRSoft.
	All Rights Reserved. */

#include <stdio.h>
#include "mcread.h"


long CheckMBHeader(in, filetypestr)
	FILE *in;
	char *filetypestr;
	
	/*	See if this file is in MacBinary II format, and if it is, get
		some information about the file.  Either way, after calling
		this routine the file pointer will be at the start of the
		data fork.	It returns the total number of bytes in the
		data fork, or 0 if a mbh was not detected. */
		
{
	register long 	dataforklen;	
	register short	zero;
	
	*filetypestr = '\0';
	
	zero = getc(in);
	if (zero != '\0') goto fail;
	
	if (fseek(in, (long) 74, SEEK_SET)) goto fail;
	zero = getc(in);
	if (zero != '\0') goto fail;
	
	if (fseek(in, (long) 83, SEEK_SET)) goto fail;
	zero = getc(in);
	if (zero != '\0') goto fail;
	
	/* if we got this far, its gotta be macbinary. */
		
	if (fseek(in, (long) 83, SEEK_SET)) goto fail;
	dataforklen = (long) Getl(in);
	
	if (fseek(in, (long) 65, SEEK_SET)) goto fail;
	(void) fgets(filetypestr, 8, in);
	filetypestr[4] = '\0';
	
	(void) fseek(in, (long) 128, SEEK_SET);
	return (dataforklen);	/* We made it! */

fail:
	(void) fseek(in, (long) 0, SEEK_SET);
	return ((long) -1);
}	/* CheckMBHeader */

/* eof */