/* mcread: mcread.h */
/*	COPYRIGHT NOTICE:
	All mcread code is Copyright (C) 1991, Mike Gleason Jr.  All
	Rights reserved, use at your own risk, blah, blah, blah.
	Feel free to glean from or modify the code as you wish... but, you
	must retain this notice, keep my shareware notice intact, and
	not tack on additional fees for yourself.  You must also provide
	source code on request to anyone who asks for it. 
	
	I'd like to see others add on other modules, like those to read
	Microsoft Word, WriteNow, FullWrite, and MacWrite II.  I suppose
	support for MacWrite 2.2 should also be added...  */
	
/* 	IMPORTANT:
		make sure the size of a MacLongword is 4 bytes, and
		insure that the size of a MacWord is 2 bytes.  */

/*	VERSION HISTORY:
	1.0   --   (MJG, Jun '91) Initial "release."
	1.0.1 --   (MJG, Jun '91) Fixed a silly bug in TEXT reader.  */

#if defined(THINK_C) || defined(applec)

#define READ_BINARY 			"rb"
typedef long int MacLongword;	/* these should work on both Think & MPW. */
typedef short int MacWord;

#else

#define READ_BINARY 			"r"
typedef long MacLongword;		/* may need to be changed! */
typedef short MacWord;			/* may need to be changed! */

#endif	/* if unix */



#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#endif

#ifndef FALSE
#define FALSE 0
#define TRUE 1
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 1
#endif

#ifndef EXIT_FAILURE
#define EXIT_FAILURE 0
#endif

#define USAGE "\n\t\
-tN (tab = N spaces)\n\t\
-wN (line width)\n\t\
-pN (pager, pauses every N lines.  N is optional (default=23)).\n\t\
files...\n\n\
mcread 1.0 -- (C) 1991 by Mike Gleason Jr., NCEMRSoft.\n\
mcread can decode MacWrite, TeachText, and TEXT files, created on\n\
Apple Macintosh(tm) computers, for reading on other platforms.\n\
This is Un*x ShareWare.  If you use this tool, you can show your\n\
gratitude in one or both of the following ways:\n\
  1. Whip out a 1$US bill (or the equivalent foreign currency;\n\
     I like foreign coins) and mail it to the address below;\n\
     It's only a dollar, and it goes towards a good cause: my tuition!\n\
  2. Mail me a short note written on your company stationery saying\n\
     how useful this is to you, blah, blah, blah.  This is for\n\
     the scholarship committee here at the University of Nebraska;\n\
     If I can hand in a bunch of these letters with my scholarship\n\
     form, they'll be impressed, and maybe give me a grant!\n\
Thanks!!!\n\
Mike Gleason\n\
5705 North 117th Plaza, Omaha, NE, USA, 68164."

#define MACWRITE_TYPE					"WORD"
#define MACWRITE_CREATOR				"MACA"	/* (Not used, though.) */
#define TEXT_TYPE						"TEXT"
#define TEACHTEXT_TYPE					"ttro"
#define WORD_TYPE						"WDBN"
#define STR_TYPE						"STR "

#define isspace(c)			( (c)==' ' || (c)=='\r' || (c)=='\t' )
#define EIGHTBIT(c)			( (c) > 0x7f )
#define NONPRINTING(c)		( !isspace(c) && ((c)<' ' || (c)==0x7f) )
#define HARDSPACE			0xca

#ifdef NOT_USED
typedef struct
{
	unsigned char	version;				/* 000: should be zero. */
	unsigned char	nameLen;				/* 001: */
	unsigned char	name[63];				/* 002: */
	unsigned long	fileType;				/* 065: */
	unsigned long	fileCreator;			/* 069: */
	unsigned char	finderFlagsHiByte;		/* 073: */
	unsigned char	zero1;					/* 074: Must be zero. */
	unsigned short	vertWindowPos;			/* 075: Obselete. */
	unsigned short	horizWindowPos;			/* 077: Obselete. */
	unsigned short	folderID;				/* 079: Obselete. */
	unsigned char	protected;				/* 081: Obselete. */
	unsigned char	zero2;					/* 082: Must be zero. */
	unsigned long	dataForkLen;			/* 083: */
	unsigned long	rsrcForkLen;			/* 087: */
	unsigned long	creationDate;			/* 091: */
	unsigned long	modificationDate;		/* 095: */
	unsigned short	getInfoLen;				/* 099: Obselete. */
	unsigned char	finderFlagsLoByte;		/* 101: */
	unsigned char	zeros[14];				/* 102: */
	unsigned long	totalUnpackLen;			/* 116: Obselete. */
	unsigned short	secondaryHeaderLen;		/* 120: Obselete. */
	unsigned char	uploadVersion;			/* 122: Must be 129. */
	unsigned char	minDecodeVersion;		/* 123: Must be 129. */
	unsigned short	CRC;					/* 124: Don't forget this! */
	unsigned short	unused;					/* 126: */
} MBHeader;
#endif

/* protos */

/* mbinary.c: */
long 							CheckMBHeader ();

/* wordwrap.c: */
int								wwInit ();
int								wwPutchar ();
int								wwFlush ();
int								CheckPage ();

/* macwrite.c: */
int								Getn ();
int								thrash_macwrite ();
int								FindCommon ();

/* text.c: */
int								thrash_text ();

/* main.c: */
int								thrash ();
MacWord							Getw ();
MacLongword						Getl ();
