/*
 * FILE : glkc_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Build 883)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
/***********************************************************************
 * $Header: /cvsroot/SWIG1.1/swig_lib/python/python.swg,v 1.5 1999/11/05 21:45:13 beazley Exp $
 * swig_lib/python/python.cfg
 *
 * Contains variable linking and pointer type-checking code.
 ************************************************************************/

#include <string.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"

/* Definitions for Windows/Unix exporting */
#if defined(_WIN32) || defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a) __declspec(dllexport) a
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a) a _export
#	else
#	    define SWIGEXPORT(a) a
#	endif
#   endif
#else
#   define SWIGEXPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGSTATICRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGSTATICRUNTIME(a) static a
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATICRUNTIME(PyObject *)
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATICRUNTIME(void)
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}

/* -----------------------------------------------------------------------------
 * Pointer type-checking
 * ----------------------------------------------------------------------------- */

/* SWIG pointer structure */
typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */
typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */
#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Register a new datatype with the type-checker */
SWIGSTATICRUNTIME(void) 
SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {
  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */
  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
  }

  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++) {
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN++];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
  }

  /* Check for existing entries */
  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */
SWIGSTATICRUNTIME(void) 
SWIG_MakePtr(char *c, const void *ptr, char *type) {
  static char hex[17] = "0123456789abcdef";
  unsigned long p, s;
  char result[24], *r; 
  r = result;
  p = (unsigned long) ptr;
  if (p > 0) {
    while (p > 0) {
      s = p & 0xf;
      *(r++) = hex[s];
      p = p >> 4;
    }
    *r = '_';
    while (r >= result)
      *(c++) = *(r--);
    strcpy (c, type);
  } else {
    strcpy (c, "NULL");
  }
}

/* Function for getting a pointer value */
SWIGSTATICRUNTIME(char *) 
SWIG_GetPtr(char *c, void **ptr, char *t)
{
  unsigned long p;
  char temp_type[256], *name;
  int  i, len, start, end;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  register int d;

  p = 0;
  /* Pointer values must start with leading underscore */
  if (*c != '_') {
    *ptr = (void *) 0;
    if (strcmp(c,"NULL") == 0) return (char *) 0;
    else return c;
  }
  c++;
  /* Extract hex value from pointer */
  while (d = *c) {
    if ((d >= '0') && (d <= '9'))
      p = (p << 4) + (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      p = (p << 4) + (d - ('a'-10));
    else
      break; 
    c++;
  }
  *ptr = (void *) p;
  if ((!t) || (strcmp(t,c)==0)) return (char *) 0;

  if (!SwigPtrSort) {
    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
    for (i = 0; i < 256; i++) SwigStart[i] = SwigPtrN;
    for (i = SwigPtrN-1; i >= 0; i--) SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
    for (i = 255; i >= 1; i--) {
      if (SwigStart[i-1] > SwigStart[i])
	SwigStart[i-1] = SwigStart[i];
    }
    SwigPtrSort = 1;
    for (i = 0; i < SWIG_CACHESIZE; i++) SwigCache[i].stat = 0;
  }
  /* First check cache for matches.  Uses last cache value as starting point */
  cache = &SwigCache[SwigLastCache];
  for (i = 0; i < SWIG_CACHESIZE; i++) {
    if (cache->stat && (strcmp(t,cache->name) == 0) && (strcmp(c,cache->mapped) == 0)) {
      cache->stat++;
      if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
      return (char *) 0;
    }
    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
    if (!SwigLastCache) cache = SwigCache;
    else cache++;
  }
  /* Type mismatch.  Look through type-mapping table */
  start = SwigStart[(int) t[1]];
  end = SwigStart[(int) t[1]+1];
  sp = &SwigPtrTable[start];

  /* Try to find a match */
  while (start <= end) {
    if (strncmp(t,sp->name,sp->len) == 0) {
      name = sp->name;
      len = sp->len;
      tp = sp->next;
      /* Try to find entry for our given datatype */
      while(tp) {
	if (tp->len >= 255) {
	  return c;
	}
	strcpy(temp_type,tp->name);
	strncat(temp_type,t+len,255-tp->len);
	if (strcmp(c,temp_type) == 0) {
	  strcpy(SwigCache[SwigCacheIndex].mapped,c);
	  strcpy(SwigCache[SwigCacheIndex].name,t);
	  SwigCache[SwigCacheIndex].stat = 1;
	  SwigCache[SwigCacheIndex].tp = tp;
	  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
	  /* Get pointer value */
	  *ptr = (void *) p;
	  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
	  return (char *) 0;
	}
	tp = tp->next;
      }
    }
    sp++;
    start++;
  }
  return c;
} 

/* New object-based GetPointer function. This uses the Python abstract
 * object interface to automatically dereference the 'this' attribute
 * of shadow objects. */

SWIGSTATICRUNTIME(char *)
SWIG_GetPtrObj(PyObject *obj, void **ptr, char *type) {
  PyObject *sobj = obj;
  char     *str;
  if (!PyString_Check(obj)) {
    sobj = PyObject_GetAttrString(obj,"this");
    if (!sobj) return "";
  }
  str = PyString_AsString(sobj);
  return SWIG_GetPtr(str,ptr,type);
}

#ifdef __cplusplus
}
#endif


#define SWIG_init    initglkc

#define SWIG_name    "glkc"

#include "glkc.h"
#include "ref_llhash.h"
#include "buf_llhash.h"

/* save buffer_t objects so they can be used by the Glk lib */

REF_LLHTABLE gBufferRefs;
BUF_LLHTABLE gSavedBuffers;

void refBuffer(char *buf)
{
	if (buf != NULL) {
		ref_hash_struct *h;
		h = ref_llhlookup(gBufferRefs, (int) buf);
		if (NULL == h) {
			ref_hash_struct newh;
			newh.buf = buf;
			newh.refcount = 1;
			ref_llhinsert(gBufferRefs, newh);
		} else {
			h->refcount++;
		}
	}
}

void unrefBuffer(char *buf)
{
	if (buf != NULL) {
		ref_hash_struct *h;
		h = ref_llhlookup(gBufferRefs, (int) buf);
		if (NULL == h) {
			free(buf);
		} else {
			h->refcount--;
			if (0 == h->refcount) {
				free(h->buf);
				ref_llhremove(gBufferRefs, (int) buf);
			}
		}
	}
}

void saveBuffer(char *buf, void *key)
{
	if (buf != NULL && key != NULL) {
		buf_hash_struct h;
		h.glkobj = key;
		h.buf = buf;
		buf_llhinsert(gSavedBuffers, h);
		refBuffer(buf);
	}
}

void releaseBuffer(void *key)
{
	if (key != NULL) {
		buf_hash_struct *h;
		h = buf_llhlookup(gSavedBuffers, (int) key);
		if (h != NULL) {
			unrefBuffer(h->buf);
			buf_llhremove(gSavedBuffers, (int) key);
		}
	}
}

/* event_t manipulators */

event_t *new_event_t(char *str) {
	event_t *ptr;
	if (SWIG_GetPtr(str, (void **) &ptr, "_event_t_p") == NULL) {
		return ptr;
	} else {
		/* FIXME: error message? */
		return NULL;
	}
}

void delete_event_t(event_t *ptr) {
	if (ptr != NULL) {
		free(ptr);
	}
}

/* window_t manipulators */

window_t *new_window_t(char *str) {
	window_t *ptr;
	if (SWIG_GetPtr(str, (void **) &ptr, "_window_t_p") == NULL) {
		return ptr;
	} else {
		/* FIXME: error message? */
		return NULL;
	}
}

void delete_window_t(window_t *ptr) {
}

/* stream_t manipulators */

stream_t *new_stream_t(char *str) {
	stream_t *ptr;
	if (SWIG_GetPtr(str, (void **) &ptr, "_stream_t_p") == NULL) {
		return ptr;
	} else {
		/* FIXME: error message? */
		return NULL;
	}
}

void delete_stream_t(stream_t *ptr) {
}

/* fileref_t manipulators */

fileref_t *new_fileref_t(char *str) {
	fileref_t *ptr;
	if (SWIG_GetPtr(str, (void **) &ptr, "_fileref_t_p") == NULL) {
		return ptr;
	} else {
		/* FIXME: error message? */
		return NULL;
	}
}

void delete_fileref_t(fileref_t *ptr) {
}

/* schannel_t manipulators */

schannel_t *new_schannel_t(char *str) {
	schannel_t *ptr;
	if (SWIG_GetPtr(str, (void **) &ptr, "_schannel_t_p") == NULL) {
		return ptr;
	} else {
		/* FIXME: error message? */
		return NULL;
	}
}

void delete_schannel_t(schannel_t *ptr) {
}

/* glk_exit implementation */

extern void glk_exit(void);

static PyObject *glkc_exit(PyObject *self, PyObject *args) {
	PyObject *result;

	if (!PyArg_ParseTuple(args, ":glk_exit")) {
		return NULL;
	}
	cleanup_pyglk();
	glk_exit();
	Py_INCREF(Py_None);
	result = Py_None;
	return result;
}

/* glk_gestalt_ext implementation */

extern glui32 glk_gestalt_ext(glui32 sel, glui32 val, glui32 *arr,
	glui32 arrlen);

static PyObject *glkc_gestalt_ext(PyObject *self, PyObject *args) {
	glui32 sel;
	glui32 val;
	glui32 arrlen;
	glui32 *arr;
	glui32 result;
	PyObject *resultList;
	PyObject *resultTuple;
	unsigned short i;

	if (!PyArg_ParseTuple(args, "lll:glk_gestalt_ext", &sel, &val, &arrlen)) {
		return NULL;
	}
	arr = (glui32 *) malloc(arrlen * sizeof(glui32));
	memset(arr, 0, arrlen * sizeof(glui32));
	result = glk_gestalt_ext(sel, val, arr, arrlen);
	resultTuple = PyTuple_New(2);
	PyTuple_SetItem(resultTuple, 0, Py_BuildValue("l", result));
	resultList = PyList_New(0);
	for (i = 0; i < arrlen; i++) {
		PyList_Append(resultList, Py_BuildValue("l", arr[i]));
	}
	free(arr);
	PyTuple_SetItem(resultTuple, 1, resultList);
	return resultTuple;
}

/* glk_window_close implementation */
extern void glk_window_close(window_t *win, stream_result_t *result);

static PyObject *glkc_window_close(PyObject *self, PyObject *args) {
	winid_t win;
	stream_result_t strcount;
	strid_t str;
	PyObject *winObj;
	PyObject *result;

	if (!PyArg_ParseTuple(args, "O:glk_window_close", &winObj)) {
		return NULL;
	}
	if (winObj) {
		if (winObj == Py_None) {
			win = NULL;
		} else if (SWIG_GetPtrObj(winObj, (void **) &win, "_window_t_p")) {
			PyErr_SetString(PyExc_TypeError,
				"Type error in argument 1 of glk_window_close. " \
				"Expected _window_t_p.");
			return NULL;
		}
	}

	/* unref the buffers for this window or its stream */
	str = glk_window_get_stream(win);
	releaseBuffer(win);
	releaseBuffer(str);

	glk_window_close(win, &strcount);

	result = PyTuple_New(2);
	PyTuple_SetItem(result, 0, Py_BuildValue("l", strcount.readcount));
	PyTuple_SetItem(result, 1, Py_BuildValue("l", strcount.writecount));
	return result;
}

/* glk_stream_close implementation */

extern void glk_stream_close(stream_t *str, stream_result_t *result); 

static PyObject *glkc_stream_close(PyObject *self, PyObject *args) {
	strid_t str;
	stream_result_t strcount;
	PyObject *strObj;
	PyObject *result;

	if (!PyArg_ParseTuple(args, "O:glk_stream_close", &strObj)) {
		return NULL;
	}
	if (strObj) {
		if (strObj == Py_None) {
			str = NULL;
		} else if (SWIG_GetPtrObj(strObj, (void **) &str, "_stream_t_p")) {
			PyErr_SetString(PyExc_TypeError,
				"Type error in argument 1 of glk_stream_close. " \
				"Expected _stream_t_p.");
			return NULL;
		}
	}

	/* unref the buffer for this stream */
	releaseBuffer(str);

	glk_stream_close(str, &strcount);

	result = PyTuple_New(2);
	PyTuple_SetItem(result, 0, Py_BuildValue("l", strcount.readcount));
	PyTuple_SetItem(result, 1, Py_BuildValue("l", strcount.writecount));
	return result;
}


/* glk_get_line_stream implementation */

extern glui32 glk_get_line_stream(stream_t *str, char *out, glui32 len);

static PyObject *glkc_get_line_stream(PyObject *self, PyObject *args) {
	PyObject *strObj;
	strid_t str;
	char *buf;
	glui32 len;
	glui32 numread;
	char pname[128];
	PyObject *result;

	if (!PyArg_ParseTuple(args, "Ol:glk_get_line_stream", &strObj, &len)) {
		return NULL;
	}
	if (strObj) {
		if (strObj == Py_None) {
			str = NULL;
		} else if (SWIG_GetPtrObj(strObj, (void **) &str, "_stream_t_p")) {
			PyErr_SetString(PyExc_TypeError,
				"Type error in argument 1 of glk_get_line_stream. " \
				"Expected _stream_t_p.");
			return NULL;
		}
	}
	buf = malloc(len * sizeof(char *));
	/* glk_get_line_stream only reads len-1 chars */ 
	numread = glk_get_line_stream(str, buf, len);
	result = Py_BuildValue("s", buf);
	if (buf != NULL) {
		free(buf);
	}
	return result;
}

/* glk_get_buffer_stream implementation */

extern glui32 glk_get_buffer_stream(stream_t *str, char *buf, glui32 len);

static PyObject *glkc_get_buffer_stream(PyObject *self, PyObject *args) {
	PyObject *strObj;
	strid_t str;
	char *buf;
	glui32 len;
	glui32 numread;
	char pname[128];
	PyObject *result;

	if (!PyArg_ParseTuple(args, "Ol:glk_get_buffer_stream", &strObj, &len)) {
		return NULL;
	}
	if (strObj) {
		if (strObj == Py_None) {
			str = NULL;
		} else if (SWIG_GetPtrObj(strObj, (void **) &str, "_stream_t_p")) {
			PyErr_SetString(PyExc_TypeError,
				"Type error in argument 1 of glk_get_buffer_stream. " \
				"Expected _stream_t_p.");
			return NULL;
		}
	}
	buf = malloc((len+1) * sizeof(char *));
	numread = glk_get_buffer_stream(str, buf, len);
	if (numread <= len) {
		buf[numread] = '\0';
	}
	result = Py_BuildValue("s", buf);
	if (buf != NULL) {
		free(buf);
	}
	return result;
}

/* buffer_t wraps a C buffer for glk_request_line and glk_stream_open_memory */

typedef struct glkc_buffer_struct {
	char * buf;
	unsigned long maxlen;
} buffer_t;

buffer_t *new_buffer_t(char *str, unsigned long maxlen) {
	buffer_t *buffer = (buffer_t *) malloc(sizeof(buffer_t));
	buffer->maxlen = maxlen;
	buffer->buf = (char *) malloc((maxlen+1) * sizeof(char));
	if (str == NULL) {
		buffer->buf[0] = '\0';
	} else {
		strcpy(buffer->buf, str);
	}
	refBuffer(buffer->buf);
	return buffer;
}

char *snapshot_whole_buffer(buffer_t *buffer) {
	buffer->buf[buffer->maxlen] = '\0';
	return buffer->buf;
}

char *snapshot_buffer(buffer_t *buffer, unsigned int len) {
	if (len <= buffer->maxlen) {
		buffer->buf[len] = '\0';
	}
	return buffer->buf;
}

glui32 get_buffer_maxlen(buffer_t *buffer) {
	return buffer->maxlen;
}

void delete_buffer_t(buffer_t *buffer) {
	if (buffer != NULL) {
		if (buffer->buf != NULL) {
			unrefBuffer(buffer->buf);
			buffer->buf = NULL;
		}
		
		free(buffer);
		buffer = NULL;
	}
}

/* glk_stream_open_memory implementation */

extern stream_t *glk_stream_open_memory(char *buf, glui32 buflen, glui32 fmode, glui32 rock);

static PyObject *glkc_stream_open_memory(PyObject *self, PyObject *args) {
	PyObject *bufferObj;
	buffer_t *buffer;
	char *buf;
	glui32 buflen;
	glui32 fmode;
	glui32 rock;
	strid_t stream;
	char pname[128];
	PyObject *result;

	if (!PyArg_ParseTuple(args, "Oll:glk_stream_open_memory", &bufferObj,
		&fmode, &rock))
	{
		return NULL;
	}
	if (bufferObj) {
		if (bufferObj == Py_None) {
			buffer = NULL;
		} else if (SWIG_GetPtrObj(bufferObj, (void **) &buffer,
			"_buffer_t_p"))
		{
			PyErr_SetString(PyExc_TypeError,
				"Type error in argument 1 of glk_stream_open_memory. " \
				"Expected _buffer_t_p.");
			return NULL;
		}
	}
	if (buffer) {
		buf = buffer->buf;
		buflen = buffer->maxlen;
	} else {
		buf = NULL;
		buflen = 0;
	}
	stream = glk_stream_open_memory(buf, buflen, fmode, rock);
	SWIG_MakePtr(pname, (char *) stream, "_stream_t_p");
	result = Py_BuildValue("s", pname);
	if (buf && stream) {
		/* hold a reference to the buffer until the stream is closed */
		saveBuffer(buf, stream);
	}
	return result;
}

/* glk_request_line_event implementation */

extern void glk_request_line_event(winid_t win, char *buf, glui32 maxlen,
	glui32 initlen);

static PyObject *glkc_request_line_event(PyObject *self, PyObject *args) {
	PyObject *winObj;
	PyObject *bufferObj;
	buffer_t *buffer;
	char *buf;
	winid_t win;
	glui32 maxlen;
	glui32 initlen;
	PyObject *result;

	if (!PyArg_ParseTuple(args, "OOl:glk_request_line_event", &winObj,
		&bufferObj, &initlen))
	{
		return NULL;
	}
	if (winObj) {
		if (winObj == Py_None) {
			win = NULL;
		} else if (SWIG_GetPtrObj(winObj, (void **) &win, "_window_t_p")) {
			PyErr_SetString(PyExc_TypeError,
				"Type error in argument 1 of glk_request_line_event. " \
				"Expected _window_t_p.");
			return NULL;
		}
	}
	if (bufferObj) {
		if (bufferObj == Py_None) {
			buffer = NULL;
		} else if (SWIG_GetPtrObj(bufferObj, (void **) &buffer, \
			"_buffer_t_p"))
		{
			PyErr_SetString(PyExc_TypeError,
				"Type error in argument 2 of glk_request_line_event. " \
				"Expected _buffer_t_p.");
			return NULL;
		}
	}
	if (buffer == NULL) {
		buf = NULL;
		maxlen = 0;
	} else {
		buf = buffer->buf;
		maxlen = buffer->maxlen;
	}
	glk_request_line_event(win, buf, maxlen, initlen);
	if (buf && win) {
		/* hold a reference to the buffer until the event is returned */
		saveBuffer(buf, win);
	}
	Py_INCREF(Py_None);
	result = Py_None;
	return result;
}

/* call the Python interrupt handler */

void callInterruptHandler(void) {
	/* FIXME: should probably use PyEval_CallObject */
	PyRun_SimpleString("glk.callInterruptHandler()");
	cleanup_pyglk();
}

extern void glk_tick();
extern glui32 glk_gestalt(glui32 ,glui32 );
extern unsigned char glk_char_to_lower(unsigned char );
extern unsigned char glk_char_to_upper(unsigned char );
extern window_t *glk_window_get_root();
extern window_t *glk_window_open(window_t *,glui32 ,glui32 ,glui32 ,glui32 );
extern void glk_window_get_size(window_t *,glui32 *,glui32 *);
extern void glk_window_set_arrangement(window_t *,glui32 ,glui32 ,window_t *);
extern void glk_window_get_arrangement(window_t *,glui32 *,glui32 *,window_t **);
extern window_t *glk_window_iterate(window_t *,glui32 *);
extern glui32 glk_window_get_rock(window_t *);
extern glui32 glk_window_get_type(window_t *);
extern window_t *glk_window_get_parent(window_t *);
extern window_t *glk_window_get_sibling(window_t *);
extern void glk_window_clear(window_t *);
extern void glk_window_move_cursor(window_t *,glui32 ,glui32 );
extern stream_t *glk_window_get_stream(window_t *);
extern void glk_window_set_echo_stream(window_t *,stream_t *);
extern stream_t *glk_window_get_echo_stream(window_t *);
extern void glk_set_window(window_t *);
extern stream_t *glk_stream_open_file(fileref_t *,glui32 ,glui32 );
extern stream_t *glk_stream_iterate(stream_t *,glui32 *);
extern glui32 glk_stream_get_rock(stream_t *);
extern void glk_stream_set_position(stream_t *,glsi32 ,glui32 );
extern glui32 glk_stream_get_position(stream_t *);
extern void glk_stream_set_current(stream_t *);
extern stream_t *glk_stream_get_current();
extern void glk_put_char(unsigned char );
extern void glk_put_char_stream(stream_t *,unsigned char );
extern void glk_put_string(char *);
extern void glk_put_string_stream(stream_t *,char *);
extern void glk_put_buffer(char *,glui32 );
extern void glk_put_buffer_stream(stream_t *,char *,glui32 );
extern void glk_set_style(glui32 );
extern void glk_set_style_stream(stream_t *,glui32 );
extern glsi32 glk_get_char_stream(stream_t *);
extern void glk_stylehint_set(glui32 ,glui32 ,glui32 ,glsi32 );
extern void glk_stylehint_clear(glui32 ,glui32 ,glui32 );
extern glui32 glk_style_distinguish(window_t *,glui32 ,glui32 );
extern glui32 glk_style_measure(window_t *,glui32 ,glui32 ,glui32 *);
extern fileref_t *glk_fileref_create_temp(glui32 ,glui32 );
extern fileref_t *glk_fileref_create_by_name(glui32 ,char *,glui32 );
extern fileref_t *glk_fileref_create_by_prompt(glui32 ,glui32 ,glui32 );
extern fileref_t *glk_fileref_create_from_fileref(glui32 ,fileref_t *,glui32 );
extern void glk_fileref_destroy(fileref_t *);
extern fileref_t *glk_fileref_iterate(fileref_t *,glui32 *);
extern glui32 glk_fileref_get_rock(fileref_t *);
extern void glk_fileref_delete_file(fileref_t *);
extern glui32 glk_fileref_does_file_exist(fileref_t *);
extern void glk_select(event_t *);
extern void glk_select_poll(event_t *);
extern void glk_request_timer_events(glui32 );
extern void glk_request_char_event(window_t *);
extern void glk_request_mouse_event(window_t *);
extern void glk_cancel_line_event(window_t *,event_t *);
extern void glk_cancel_char_event(window_t *);
extern void glk_cancel_mouse_event(window_t *);
extern glui32 glk_image_draw(window_t *,glui32 ,glsi32 ,glsi32 );
extern glui32 glk_image_draw_scaled(window_t *,glui32 ,glsi32 ,glsi32 ,glui32 ,glui32 );
extern glui32 glk_image_get_info(glui32 ,glui32 *,glui32 *);
extern void glk_window_flow_break(window_t *);
extern void glk_window_erase_rect(window_t *,glsi32 ,glsi32 ,glui32 ,glui32 );
extern void glk_window_fill_rect(window_t *,glui32 ,glsi32 ,glsi32 ,glui32 ,glui32 );
extern void glk_window_set_background_color(window_t *,glui32 );
extern schannel_t *glk_schannel_create(glui32 );
extern void glk_schannel_destroy(schannel_t *);
extern schannel_t *glk_schannel_iterate(schannel_t *,glui32 *);
extern glui32 glk_schannel_get_rock(schannel_t *);
extern glui32 glk_schannel_play(schannel_t *,glui32 );
extern glui32 glk_schannel_play_ext(schannel_t *,glui32 ,glui32 ,glui32 );
extern void glk_schannel_stop(schannel_t *);
extern void glk_schannel_set_volume(schannel_t *,glui32 );
extern void glk_sound_load_hint(glui32 ,glui32 );
extern void glk_set_hyperlink(glui32 );
extern void glk_set_hyperlink_stream(stream_t *,glui32 );
extern void glk_request_hyperlink_event(window_t *);
extern void glk_cancel_hyperlink_event(window_t *);
#ifdef __cplusplus
extern "C" {
#endif
static PyObject *_wrap_new_event_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    event_t * _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:new_event_t",&_arg0)) 
        return NULL;
    _result = (event_t *)new_event_t(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_event_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_delete_event_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    event_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:delete_event_t",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_event_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_event_t. Expected _event_t_p.");
        return NULL;
        }
    }
    delete_event_t(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_new_window_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:new_window_t",&_arg0)) 
        return NULL;
    _result = (window_t *)new_window_t(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_window_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_delete_window_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:delete_window_t",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_window_t. Expected _window_t_p.");
        return NULL;
        }
    }
    delete_window_t(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_new_stream_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:new_stream_t",&_arg0)) 
        return NULL;
    _result = (stream_t *)new_stream_t(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_stream_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_delete_stream_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:delete_stream_t",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_stream_t. Expected _stream_t_p.");
        return NULL;
        }
    }
    delete_stream_t(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_new_fileref_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    fileref_t * _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:new_fileref_t",&_arg0)) 
        return NULL;
    _result = (fileref_t *)new_fileref_t(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_fileref_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_delete_fileref_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    fileref_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:delete_fileref_t",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_fileref_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_fileref_t. Expected _fileref_t_p.");
        return NULL;
        }
    }
    delete_fileref_t(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_new_schannel_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    schannel_t * _result;
    char * _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"s:new_schannel_t",&_arg0)) 
        return NULL;
    _result = (schannel_t *)new_schannel_t(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_schannel_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_delete_schannel_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    schannel_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:delete_schannel_t",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_schannel_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_schannel_t. Expected _schannel_t_p.");
        return NULL;
        }
    }
    delete_schannel_t(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_new_buffer_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    buffer_t * _result;
    char * _arg0;
    unsigned long  _arg1;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"sl:new_buffer_t",&_arg0,&_arg1)) 
        return NULL;
    _result = (buffer_t *)new_buffer_t(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_buffer_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_snapshot_whole_buffer(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    buffer_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:snapshot_whole_buffer",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_buffer_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of snapshot_whole_buffer. Expected _buffer_t_p.");
        return NULL;
        }
    }
    _result = (char *)snapshot_whole_buffer(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_snapshot_buffer(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    buffer_t * _arg0;
    unsigned long  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:snapshot_buffer",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_buffer_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of snapshot_buffer. Expected _buffer_t_p.");
        return NULL;
        }
    }
    _result = (char *)snapshot_buffer(_arg0,_arg1);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_get_buffer_maxlen(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32 * _result;
    buffer_t * _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:get_buffer_maxlen",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_buffer_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of get_buffer_maxlen. Expected _buffer_t_p.");
        return NULL;
        }
    }
    _result = (glui32 *) malloc(sizeof(glui32 ));
    *(_result) = get_buffer_maxlen(_arg0);
    SWIG_MakePtr(_ptemp, (void *) _result,"_glui32_p");
    _resultobj = Py_BuildValue("s",_ptemp);
    return _resultobj;
}

static PyObject *_wrap_delete_buffer_t(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    buffer_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:delete_buffer_t",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_buffer_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of delete_buffer_t. Expected _buffer_t_p.");
        return NULL;
        }
    }
    delete_buffer_t(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_tick(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":glk_tick")) 
        return NULL;
    glk_tick();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_gestalt(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    glui32  _arg0;
    glui32  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ll:glk_gestalt",&_arg0,&_arg1)) 
        return NULL;
    _result = (glui32 )glk_gestalt(_arg0,_arg1);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_char_to_lower(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned char  _result;
    unsigned char  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"b:glk_char_to_lower",&_arg0)) 
        return NULL;
    _result = (unsigned char )glk_char_to_lower(_arg0);
    _resultobj = Py_BuildValue("b",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_char_to_upper(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned char  _result;
    unsigned char  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"b:glk_char_to_upper",&_arg0)) 
        return NULL;
    _result = (unsigned char )glk_char_to_upper(_arg0);
    _resultobj = Py_BuildValue("b",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_window_get_root(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":glk_window_get_root")) 
        return NULL;
    _result = (window_t *)glk_window_get_root();
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_window_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_window_open(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _result;
    window_t * _arg0;
    glui32  _arg1;
    glui32  _arg2;
    glui32  _arg3;
    glui32  _arg4;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Ollll:glk_window_open",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_open. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (window_t *)glk_window_open(_arg0,_arg1,_arg2,_arg3,_arg4);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_window_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_window_get_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    glui32 * _arg1;
    glui32  outval;
    glui32 * _arg2;
    glui32  outval0;
    PyObject * _argo0 = 0;

    self = self;
{
	_arg1 = &outval;
}
{
	_arg2 = &outval0;
}
    if(!PyArg_ParseTuple(args,"O:glk_window_get_size",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_get_size. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_window_get_size(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg1));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg2));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_window_set_arrangement(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    glui32  _arg1;
    glui32  _arg2;
    window_t * _arg3;
    PyObject * _argo0 = 0;
    PyObject * _argo3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OllO:glk_window_set_arrangement",&_argo0,&_arg1,&_arg2,&_argo3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_set_arrangement. Expected _window_t_p.");
        return NULL;
        }
    }
    if (_argo3) {
        if (_argo3 == Py_None) { _arg3 = NULL; }
        else if (SWIG_GetPtrObj(_argo3,(void **) &_arg3,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of glk_window_set_arrangement. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_window_set_arrangement(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_window_get_arrangement(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    glui32 * _arg1;
    glui32  outval;
    glui32 * _arg2;
    glui32  outval0;
    window_t ** _arg3;
    window_t * outval1;
    PyObject * _argo0 = 0;

    self = self;
{
	_arg1 = &outval;
}
{
	_arg2 = &outval0;
}
{
	_arg3 = &outval1;
}
    if(!PyArg_ParseTuple(args,"O:glk_window_get_arrangement",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_get_arrangement. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_window_get_arrangement(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg1));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg2));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
{
	char pname[128];
	PyObject *result;
	
	SWIG_MakePtr(pname, (char *) _arg3, "_window_t_p");
	result = Py_BuildValue("s", pname);
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_window_iterate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _result;
    window_t * _arg0;
    glui32 * _arg1;
    glui32  outval;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
{
	_arg1 = &outval;
}
    if(!PyArg_ParseTuple(args,"O:glk_window_iterate",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_iterate. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (window_t *)glk_window_iterate(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_window_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg1));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_window_get_rock(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_window_get_rock",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_get_rock. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_window_get_rock(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_window_get_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_window_get_type",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_get_type. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_window_get_type(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_window_get_parent(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _result;
    window_t * _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_window_get_parent",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_get_parent. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (window_t *)glk_window_get_parent(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_window_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_window_get_sibling(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _result;
    window_t * _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_window_get_sibling",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_get_sibling. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (window_t *)glk_window_get_sibling(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_window_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_window_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_window_clear",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_clear. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_window_clear(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_window_move_cursor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    glui32  _arg1;
    glui32  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oll:glk_window_move_cursor",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_move_cursor. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_window_move_cursor(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_window_get_stream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _result;
    window_t * _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_window_get_stream",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_get_stream. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (stream_t *)glk_window_get_stream(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_stream_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_window_set_echo_stream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    stream_t * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:glk_window_set_echo_stream",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_set_echo_stream. Expected _window_t_p.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of glk_window_set_echo_stream. Expected _stream_t_p.");
        return NULL;
        }
    }
    glk_window_set_echo_stream(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_window_get_echo_stream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _result;
    window_t * _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_window_get_echo_stream",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_get_echo_stream. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (stream_t *)glk_window_get_echo_stream(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_stream_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_set_window(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_set_window",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_set_window. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_set_window(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_stream_open_file(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _result;
    fileref_t * _arg0;
    glui32  _arg1;
    glui32  _arg2;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"Oll:glk_stream_open_file",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_fileref_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_stream_open_file. Expected _fileref_t_p.");
        return NULL;
        }
    }
    _result = (stream_t *)glk_stream_open_file(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_stream_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_stream_iterate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _result;
    stream_t * _arg0;
    glui32 * _arg1;
    glui32  outval;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
{
	_arg1 = &outval;
}
    if(!PyArg_ParseTuple(args,"O:glk_stream_iterate",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_stream_iterate. Expected _stream_t_p.");
        return NULL;
        }
    }
    _result = (stream_t *)glk_stream_iterate(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_stream_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg1));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_stream_get_rock(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    stream_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_stream_get_rock",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_stream_get_rock. Expected _stream_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_stream_get_rock(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_stream_set_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _arg0;
    glsi32  _arg1;
    glui32  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oll:glk_stream_set_position",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_stream_set_position. Expected _stream_t_p.");
        return NULL;
        }
    }
    glk_stream_set_position(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_stream_get_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    stream_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_stream_get_position",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_stream_get_position. Expected _stream_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_stream_get_position(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_stream_set_current(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_stream_set_current",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_stream_set_current. Expected _stream_t_p.");
        return NULL;
        }
    }
    glk_stream_set_current(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_stream_get_current(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _result;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,":glk_stream_get_current")) 
        return NULL;
    _result = (stream_t *)glk_stream_get_current();
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_stream_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_put_char(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned char  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"b:glk_put_char",&_arg0)) 
        return NULL;
    glk_put_char(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_put_char_stream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _arg0;
    unsigned char  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ob:glk_put_char_stream",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_put_char_stream. Expected _stream_t_p.");
        return NULL;
        }
    }
    glk_put_char_stream(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_put_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:glk_put_string",&_arg0)) 
        return NULL;
    glk_put_string(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_put_string_stream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _arg0;
    char * _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:glk_put_string_stream",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_put_string_stream. Expected _stream_t_p.");
        return NULL;
        }
    }
    glk_put_string_stream(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_put_buffer(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;
    glui32  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"sl:glk_put_buffer",&_arg0,&_arg1)) 
        return NULL;
    glk_put_buffer(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_put_buffer_stream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _arg0;
    char * _arg1;
    glui32  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osl:glk_put_buffer_stream",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_put_buffer_stream. Expected _stream_t_p.");
        return NULL;
        }
    }
    glk_put_buffer_stream(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_set_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"l:glk_set_style",&_arg0)) 
        return NULL;
    glk_set_style(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_set_style_stream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:glk_set_style_stream",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_set_style_stream. Expected _stream_t_p.");
        return NULL;
        }
    }
    glk_set_style_stream(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_get_char_stream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glsi32  _result;
    stream_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_get_char_stream",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_get_char_stream. Expected _stream_t_p.");
        return NULL;
        }
    }
    _result = (glsi32 )glk_get_char_stream(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_stylehint_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _arg0;
    glui32  _arg1;
    glui32  _arg2;
    glsi32  _arg3;

    self = self;
    if(!PyArg_ParseTuple(args,"llll:glk_stylehint_set",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    glk_stylehint_set(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_stylehint_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _arg0;
    glui32  _arg1;
    glui32  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"lll:glk_stylehint_clear",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    glk_stylehint_clear(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_style_distinguish(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    window_t * _arg0;
    glui32  _arg1;
    glui32  _arg2;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oll:glk_style_distinguish",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_style_distinguish. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_style_distinguish(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_style_measure(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    window_t * _arg0;
    glui32  _arg1;
    glui32  _arg2;
    glui32 * _arg3;
    glui32  outval;
    PyObject * _argo0 = 0;

    self = self;
{
	_arg3 = &outval;
}
    if(!PyArg_ParseTuple(args,"Oll:glk_style_measure",&_argo0,&_arg1,&_arg2)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_style_measure. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_style_measure(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("l",_result);
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg3));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_fileref_create_temp(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    fileref_t * _result;
    glui32  _arg0;
    glui32  _arg1;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"ll:glk_fileref_create_temp",&_arg0,&_arg1)) 
        return NULL;
    _result = (fileref_t *)glk_fileref_create_temp(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_fileref_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_fileref_create_by_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    fileref_t * _result;
    glui32  _arg0;
    char * _arg1;
    glui32  _arg2;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"lsl:glk_fileref_create_by_name",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (fileref_t *)glk_fileref_create_by_name(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_fileref_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_fileref_create_by_prompt(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    fileref_t * _result;
    glui32  _arg0;
    glui32  _arg1;
    glui32  _arg2;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"lll:glk_fileref_create_by_prompt",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (fileref_t *)glk_fileref_create_by_prompt(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_fileref_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_fileref_create_from_fileref(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    fileref_t * _result;
    glui32  _arg0;
    fileref_t * _arg1;
    glui32  _arg2;
    PyObject * _argo1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"lOl:glk_fileref_create_from_fileref",&_arg0,&_argo1,&_arg2)) 
        return NULL;
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_fileref_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of glk_fileref_create_from_fileref. Expected _fileref_t_p.");
        return NULL;
        }
    }
    _result = (fileref_t *)glk_fileref_create_from_fileref(_arg0,_arg1,_arg2);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_fileref_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_fileref_destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    fileref_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_fileref_destroy",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_fileref_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_fileref_destroy. Expected _fileref_t_p.");
        return NULL;
        }
    }
    glk_fileref_destroy(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_fileref_iterate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    fileref_t * _result;
    fileref_t * _arg0;
    glui32 * _arg1;
    glui32  outval;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
{
	_arg1 = &outval;
}
    if(!PyArg_ParseTuple(args,"O:glk_fileref_iterate",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_fileref_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_fileref_iterate. Expected _fileref_t_p.");
        return NULL;
        }
    }
    _result = (fileref_t *)glk_fileref_iterate(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_fileref_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg1));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_fileref_get_rock(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    fileref_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_fileref_get_rock",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_fileref_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_fileref_get_rock. Expected _fileref_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_fileref_get_rock(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_fileref_delete_file(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    fileref_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_fileref_delete_file",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_fileref_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_fileref_delete_file. Expected _fileref_t_p.");
        return NULL;
        }
    }
    glk_fileref_delete_file(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_fileref_does_file_exist(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    fileref_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_fileref_does_file_exist",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_fileref_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_fileref_does_file_exist. Expected _fileref_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_fileref_does_file_exist(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_select(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    event_t * _arg0;
    event_t * outval;

    self = self;
{
	_arg0 = (event_t *) malloc(sizeof(event_t));
}
    if(!PyArg_ParseTuple(args,":glk_select")) 
        return NULL;
    glk_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	char pname[128];
	PyObject *result;

	/* unref the buffer if this is a line input event */
	if (_arg0->type == evtype_LineInput) {
		releaseBuffer(_arg0->win);
	}

	SWIG_MakePtr(pname, (char *) _arg0, "_event_t_p");
	result = Py_BuildValue("s", pname);
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_select_poll(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    event_t * _arg0;
    event_t * outval;

    self = self;
{
	_arg0 = (event_t *) malloc(sizeof(event_t));
}
    if(!PyArg_ParseTuple(args,":glk_select_poll")) 
        return NULL;
    glk_select_poll(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	char pname[128];
	PyObject *result;

	/* unref the buffer if this is a line input event */
	if (_arg0->type == evtype_LineInput) {
		releaseBuffer(_arg0->win);
	}

	SWIG_MakePtr(pname, (char *) _arg0, "_event_t_p");
	result = Py_BuildValue("s", pname);
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_request_timer_events(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"l:glk_request_timer_events",&_arg0)) 
        return NULL;
    glk_request_timer_events(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_request_char_event(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_request_char_event",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_request_char_event. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_request_char_event(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_request_mouse_event(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_request_mouse_event",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_request_mouse_event. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_request_mouse_event(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_cancel_line_event(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    event_t * _arg1;
    event_t * outval;
    PyObject * _argo0 = 0;

    self = self;
{
	_arg1 = (event_t *) malloc(sizeof(event_t));
}
    if(!PyArg_ParseTuple(args,"O:glk_cancel_line_event",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_cancel_line_event. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_cancel_line_event(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
	char pname[128];
	PyObject *result;

	/* unref the buffer if this is a line input event */
	if (_arg1->type == evtype_LineInput) {
		releaseBuffer(_arg1->win);
	}

	SWIG_MakePtr(pname, (char *) _arg1, "_event_t_p");
	result = Py_BuildValue("s", pname);
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_cancel_char_event(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_cancel_char_event",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_cancel_char_event. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_cancel_char_event(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_cancel_mouse_event(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_cancel_mouse_event",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_cancel_mouse_event. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_cancel_mouse_event(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_image_draw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    window_t * _arg0;
    glui32  _arg1;
    glsi32  _arg2;
    glsi32  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Olll:glk_image_draw",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_image_draw. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_image_draw(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_image_draw_scaled(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    window_t * _arg0;
    glui32  _arg1;
    glsi32  _arg2;
    glsi32  _arg3;
    glui32  _arg4;
    glui32  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Olllll:glk_image_draw_scaled",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_image_draw_scaled. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_image_draw_scaled(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_image_get_info(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    glui32  _arg0;
    glui32 * _arg1;
    glui32  outval;
    glui32 * _arg2;
    glui32  outval0;

    self = self;
{
	_arg1 = &outval;
}
{
	_arg2 = &outval0;
}
    if(!PyArg_ParseTuple(args,"l:glk_image_get_info",&_arg0)) 
        return NULL;
    _result = (glui32 )glk_image_get_info(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("l",_result);
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg1));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg2));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_window_flow_break(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_window_flow_break",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_flow_break. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_window_flow_break(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_window_erase_rect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    glsi32  _arg1;
    glsi32  _arg2;
    glui32  _arg3;
    glui32  _arg4;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ollll:glk_window_erase_rect",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_erase_rect. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_window_erase_rect(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_window_fill_rect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    glui32  _arg1;
    glsi32  _arg2;
    glsi32  _arg3;
    glui32  _arg4;
    glui32  _arg5;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Olllll:glk_window_fill_rect",&_argo0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_fill_rect. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_window_fill_rect(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_window_set_background_color(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:glk_window_set_background_color",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_window_set_background_color. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_window_set_background_color(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_schannel_create(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    schannel_t * _result;
    glui32  _arg0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"l:glk_schannel_create",&_arg0)) 
        return NULL;
    _result = (schannel_t *)glk_schannel_create(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_schannel_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

static PyObject *_wrap_glk_schannel_destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    schannel_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_schannel_destroy",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_schannel_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_schannel_destroy. Expected _schannel_t_p.");
        return NULL;
        }
    }
    glk_schannel_destroy(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_schannel_iterate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    schannel_t * _result;
    schannel_t * _arg0;
    glui32 * _arg1;
    glui32  outval;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
{
	_arg1 = &outval;
}
    if(!PyArg_ParseTuple(args,"O:glk_schannel_iterate",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_schannel_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_schannel_iterate. Expected _schannel_t_p.");
        return NULL;
        }
    }
    _result = (schannel_t *)glk_schannel_iterate(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_schannel_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
{
	PyObject *result;
	
	result = Py_BuildValue("l", *(_arg1));
	if ((!_resultobj) || (_resultobj == Py_None)) {
		_resultobj = result;
	} else {
		if (!PyList_Check(_resultobj)) {
			PyObject *temp = _resultobj;
			_resultobj = PyList_New(0);
			PyList_Append(_resultobj, temp);
			Py_XDECREF(temp);
		}
		PyList_Append(_resultobj, result);
		Py_XDECREF(result);
	}
}
    return _resultobj;
}

static PyObject *_wrap_glk_schannel_get_rock(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    schannel_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_schannel_get_rock",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_schannel_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_schannel_get_rock. Expected _schannel_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_schannel_get_rock(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_schannel_play(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    schannel_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:glk_schannel_play",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_schannel_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_schannel_play. Expected _schannel_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_schannel_play(_arg0,_arg1);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_schannel_play_ext(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    schannel_t * _arg0;
    glui32  _arg1;
    glui32  _arg2;
    glui32  _arg3;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Olll:glk_schannel_play_ext",&_argo0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_schannel_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_schannel_play_ext. Expected _schannel_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )glk_schannel_play_ext(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyObject *_wrap_glk_schannel_stop(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    schannel_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_schannel_stop",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_schannel_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_schannel_stop. Expected _schannel_t_p.");
        return NULL;
        }
    }
    glk_schannel_stop(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_schannel_set_volume(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    schannel_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:glk_schannel_set_volume",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_schannel_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_schannel_set_volume. Expected _schannel_t_p.");
        return NULL;
        }
    }
    glk_schannel_set_volume(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_sound_load_hint(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _arg0;
    glui32  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ll:glk_sound_load_hint",&_arg0,&_arg1)) 
        return NULL;
    glk_sound_load_hint(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_set_hyperlink(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"l:glk_set_hyperlink",&_arg0)) 
        return NULL;
    glk_set_hyperlink(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_set_hyperlink_stream(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    stream_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:glk_set_hyperlink_stream",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_set_hyperlink_stream. Expected _stream_t_p.");
        return NULL;
        }
    }
    glk_set_hyperlink_stream(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_request_hyperlink_event(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_request_hyperlink_event",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_request_hyperlink_event. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_request_hyperlink_event(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_glk_cancel_hyperlink_event(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:glk_cancel_hyperlink_event",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of glk_cancel_hyperlink_event. Expected _window_t_p.");
        return NULL;
        }
    }
    glk_cancel_hyperlink_event(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

#define event_struct_type_set(_swigobj,_swigval) (_swigobj->type = _swigval,_swigval)
static PyObject *_wrap_event_t_type_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    event_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:event_t_type_set",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_event_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of event_t_type_set. Expected _event_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )event_struct_type_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

#define event_struct_type_get(_swigobj) ((glui32 ) _swigobj->type)
static PyObject *_wrap_event_t_type_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    event_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:event_t_type_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_event_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of event_t_type_get. Expected _event_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )event_struct_type_get(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

#define event_struct_win_set(_swigobj,_swigval) (_swigobj->win = _swigval,_swigval)
static PyObject *_wrap_event_t_win_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _result;
    event_t * _arg0;
    window_t * _arg1;
    PyObject * _argo0 = 0;
    PyObject * _argo1 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"OO:event_t_win_set",&_argo0,&_argo1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_event_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of event_t_win_set. Expected _event_t_p.");
        return NULL;
        }
    }
    if (_argo1) {
        if (_argo1 == Py_None) { _arg1 = NULL; }
        else if (SWIG_GetPtrObj(_argo1,(void **) &_arg1,"_window_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of event_t_win_set. Expected _window_t_p.");
        return NULL;
        }
    }
    _result = (window_t *)event_struct_win_set(_arg0,_arg1);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_window_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

#define event_struct_win_get(_swigobj) ((window_t *) _swigobj->win)
static PyObject *_wrap_event_t_win_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    window_t * _result;
    event_t * _arg0;
    PyObject * _argo0 = 0;
    char _ptemp[128];

    self = self;
    if(!PyArg_ParseTuple(args,"O:event_t_win_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_event_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of event_t_win_get. Expected _event_t_p.");
        return NULL;
        }
    }
    _result = (window_t *)event_struct_win_get(_arg0);
    if (_result) {
        SWIG_MakePtr(_ptemp, (char *) _result,"_window_t_p");
        _resultobj = Py_BuildValue("s",_ptemp);
    } else {
        Py_INCREF(Py_None);
        _resultobj = Py_None;
    }
    return _resultobj;
}

#define event_struct_val1_set(_swigobj,_swigval) (_swigobj->val1 = _swigval,_swigval)
static PyObject *_wrap_event_t_val1_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    event_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:event_t_val1_set",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_event_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of event_t_val1_set. Expected _event_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )event_struct_val1_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

#define event_struct_val1_get(_swigobj) ((glui32 ) _swigobj->val1)
static PyObject *_wrap_event_t_val1_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    event_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:event_t_val1_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_event_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of event_t_val1_get. Expected _event_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )event_struct_val1_get(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

#define event_struct_val2_set(_swigobj,_swigval) (_swigobj->val2 = _swigval,_swigval)
static PyObject *_wrap_event_t_val2_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    event_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:event_t_val2_set",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_event_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of event_t_val2_set. Expected _event_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )event_struct_val2_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

#define event_struct_val2_get(_swigobj) ((glui32 ) _swigobj->val2)
static PyObject *_wrap_event_t_val2_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    event_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:event_t_val2_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_event_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of event_t_val2_get. Expected _event_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )event_struct_val2_get(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

#define stream_result_struct_readcount_set(_swigobj,_swigval) (_swigobj->readcount = _swigval,_swigval)
static PyObject *_wrap_stream_result_t_readcount_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    stream_result_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:stream_result_t_readcount_set",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_result_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of stream_result_t_readcount_set. Expected _stream_result_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )stream_result_struct_readcount_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

#define stream_result_struct_readcount_get(_swigobj) ((glui32 ) _swigobj->readcount)
static PyObject *_wrap_stream_result_t_readcount_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    stream_result_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:stream_result_t_readcount_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_result_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of stream_result_t_readcount_get. Expected _stream_result_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )stream_result_struct_readcount_get(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

#define stream_result_struct_writecount_set(_swigobj,_swigval) (_swigobj->writecount = _swigval,_swigval)
static PyObject *_wrap_stream_result_t_writecount_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    stream_result_t * _arg0;
    glui32  _arg1;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ol:stream_result_t_writecount_set",&_argo0,&_arg1)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_result_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of stream_result_t_writecount_set. Expected _stream_result_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )stream_result_struct_writecount_set(_arg0,_arg1);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

#define stream_result_struct_writecount_get(_swigobj) ((glui32 ) _swigobj->writecount)
static PyObject *_wrap_stream_result_t_writecount_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    glui32  _result;
    stream_result_t * _arg0;
    PyObject * _argo0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:stream_result_t_writecount_get",&_argo0)) 
        return NULL;
    if (_argo0) {
        if (_argo0 == Py_None) { _arg0 = NULL; }
        else if (SWIG_GetPtrObj(_argo0,(void **) &_arg0,"_stream_result_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 1 of stream_result_t_writecount_get. Expected _stream_result_t_p.");
        return NULL;
        }
    }
    _result = (glui32 )stream_result_struct_writecount_get(_arg0);
    _resultobj = Py_BuildValue("l",_result);
    return _resultobj;
}

static PyMethodDef glkcMethods[] = {
	 { "stream_result_t_writecount_get", _wrap_stream_result_t_writecount_get, METH_VARARGS },
	 { "stream_result_t_writecount_set", _wrap_stream_result_t_writecount_set, METH_VARARGS },
	 { "stream_result_t_readcount_get", _wrap_stream_result_t_readcount_get, METH_VARARGS },
	 { "stream_result_t_readcount_set", _wrap_stream_result_t_readcount_set, METH_VARARGS },
	 { "event_t_val2_get", _wrap_event_t_val2_get, METH_VARARGS },
	 { "event_t_val2_set", _wrap_event_t_val2_set, METH_VARARGS },
	 { "event_t_val1_get", _wrap_event_t_val1_get, METH_VARARGS },
	 { "event_t_val1_set", _wrap_event_t_val1_set, METH_VARARGS },
	 { "event_t_win_get", _wrap_event_t_win_get, METH_VARARGS },
	 { "event_t_win_set", _wrap_event_t_win_set, METH_VARARGS },
	 { "event_t_type_get", _wrap_event_t_type_get, METH_VARARGS },
	 { "event_t_type_set", _wrap_event_t_type_set, METH_VARARGS },
	 { "glk_cancel_hyperlink_event", _wrap_glk_cancel_hyperlink_event, METH_VARARGS },
	 { "glk_request_hyperlink_event", _wrap_glk_request_hyperlink_event, METH_VARARGS },
	 { "glk_set_hyperlink_stream", _wrap_glk_set_hyperlink_stream, METH_VARARGS },
	 { "glk_set_hyperlink", _wrap_glk_set_hyperlink, METH_VARARGS },
	 { "glk_sound_load_hint", _wrap_glk_sound_load_hint, METH_VARARGS },
	 { "glk_schannel_set_volume", _wrap_glk_schannel_set_volume, METH_VARARGS },
	 { "glk_schannel_stop", _wrap_glk_schannel_stop, METH_VARARGS },
	 { "glk_schannel_play_ext", _wrap_glk_schannel_play_ext, METH_VARARGS },
	 { "glk_schannel_play", _wrap_glk_schannel_play, METH_VARARGS },
	 { "glk_schannel_get_rock", _wrap_glk_schannel_get_rock, METH_VARARGS },
	 { "glk_schannel_iterate", _wrap_glk_schannel_iterate, METH_VARARGS },
	 { "glk_schannel_destroy", _wrap_glk_schannel_destroy, METH_VARARGS },
	 { "glk_schannel_create", _wrap_glk_schannel_create, METH_VARARGS },
	 { "glk_window_set_background_color", _wrap_glk_window_set_background_color, METH_VARARGS },
	 { "glk_window_fill_rect", _wrap_glk_window_fill_rect, METH_VARARGS },
	 { "glk_window_erase_rect", _wrap_glk_window_erase_rect, METH_VARARGS },
	 { "glk_window_flow_break", _wrap_glk_window_flow_break, METH_VARARGS },
	 { "glk_image_get_info", _wrap_glk_image_get_info, METH_VARARGS },
	 { "glk_image_draw_scaled", _wrap_glk_image_draw_scaled, METH_VARARGS },
	 { "glk_image_draw", _wrap_glk_image_draw, METH_VARARGS },
	 { "glk_cancel_mouse_event", _wrap_glk_cancel_mouse_event, METH_VARARGS },
	 { "glk_cancel_char_event", _wrap_glk_cancel_char_event, METH_VARARGS },
	 { "glk_cancel_line_event", _wrap_glk_cancel_line_event, METH_VARARGS },
	 { "glk_request_mouse_event", _wrap_glk_request_mouse_event, METH_VARARGS },
	 { "glk_request_char_event", _wrap_glk_request_char_event, METH_VARARGS },
	 { "glk_request_timer_events", _wrap_glk_request_timer_events, METH_VARARGS },
	 { "glk_select_poll", _wrap_glk_select_poll, METH_VARARGS },
	 { "glk_select", _wrap_glk_select, METH_VARARGS },
	 { "glk_fileref_does_file_exist", _wrap_glk_fileref_does_file_exist, METH_VARARGS },
	 { "glk_fileref_delete_file", _wrap_glk_fileref_delete_file, METH_VARARGS },
	 { "glk_fileref_get_rock", _wrap_glk_fileref_get_rock, METH_VARARGS },
	 { "glk_fileref_iterate", _wrap_glk_fileref_iterate, METH_VARARGS },
	 { "glk_fileref_destroy", _wrap_glk_fileref_destroy, METH_VARARGS },
	 { "glk_fileref_create_from_fileref", _wrap_glk_fileref_create_from_fileref, METH_VARARGS },
	 { "glk_fileref_create_by_prompt", _wrap_glk_fileref_create_by_prompt, METH_VARARGS },
	 { "glk_fileref_create_by_name", _wrap_glk_fileref_create_by_name, METH_VARARGS },
	 { "glk_fileref_create_temp", _wrap_glk_fileref_create_temp, METH_VARARGS },
	 { "glk_style_measure", _wrap_glk_style_measure, METH_VARARGS },
	 { "glk_style_distinguish", _wrap_glk_style_distinguish, METH_VARARGS },
	 { "glk_stylehint_clear", _wrap_glk_stylehint_clear, METH_VARARGS },
	 { "glk_stylehint_set", _wrap_glk_stylehint_set, METH_VARARGS },
	 { "glk_get_char_stream", _wrap_glk_get_char_stream, METH_VARARGS },
	 { "glk_set_style_stream", _wrap_glk_set_style_stream, METH_VARARGS },
	 { "glk_set_style", _wrap_glk_set_style, METH_VARARGS },
	 { "glk_put_buffer_stream", _wrap_glk_put_buffer_stream, METH_VARARGS },
	 { "glk_put_buffer", _wrap_glk_put_buffer, METH_VARARGS },
	 { "glk_put_string_stream", _wrap_glk_put_string_stream, METH_VARARGS },
	 { "glk_put_string", _wrap_glk_put_string, METH_VARARGS },
	 { "glk_put_char_stream", _wrap_glk_put_char_stream, METH_VARARGS },
	 { "glk_put_char", _wrap_glk_put_char, METH_VARARGS },
	 { "glk_stream_get_current", _wrap_glk_stream_get_current, METH_VARARGS },
	 { "glk_stream_set_current", _wrap_glk_stream_set_current, METH_VARARGS },
	 { "glk_stream_get_position", _wrap_glk_stream_get_position, METH_VARARGS },
	 { "glk_stream_set_position", _wrap_glk_stream_set_position, METH_VARARGS },
	 { "glk_stream_get_rock", _wrap_glk_stream_get_rock, METH_VARARGS },
	 { "glk_stream_iterate", _wrap_glk_stream_iterate, METH_VARARGS },
	 { "glk_stream_open_file", _wrap_glk_stream_open_file, METH_VARARGS },
	 { "glk_set_window", _wrap_glk_set_window, METH_VARARGS },
	 { "glk_window_get_echo_stream", _wrap_glk_window_get_echo_stream, METH_VARARGS },
	 { "glk_window_set_echo_stream", _wrap_glk_window_set_echo_stream, METH_VARARGS },
	 { "glk_window_get_stream", _wrap_glk_window_get_stream, METH_VARARGS },
	 { "glk_window_move_cursor", _wrap_glk_window_move_cursor, METH_VARARGS },
	 { "glk_window_clear", _wrap_glk_window_clear, METH_VARARGS },
	 { "glk_window_get_sibling", _wrap_glk_window_get_sibling, METH_VARARGS },
	 { "glk_window_get_parent", _wrap_glk_window_get_parent, METH_VARARGS },
	 { "glk_window_get_type", _wrap_glk_window_get_type, METH_VARARGS },
	 { "glk_window_get_rock", _wrap_glk_window_get_rock, METH_VARARGS },
	 { "glk_window_iterate", _wrap_glk_window_iterate, METH_VARARGS },
	 { "glk_window_get_arrangement", _wrap_glk_window_get_arrangement, METH_VARARGS },
	 { "glk_window_set_arrangement", _wrap_glk_window_set_arrangement, METH_VARARGS },
	 { "glk_window_get_size", _wrap_glk_window_get_size, METH_VARARGS },
	 { "glk_window_open", _wrap_glk_window_open, METH_VARARGS },
	 { "glk_window_get_root", _wrap_glk_window_get_root, METH_VARARGS },
	 { "glk_char_to_upper", _wrap_glk_char_to_upper, METH_VARARGS },
	 { "glk_char_to_lower", _wrap_glk_char_to_lower, METH_VARARGS },
	 { "glk_gestalt", _wrap_glk_gestalt, METH_VARARGS },
	 { "glk_tick", _wrap_glk_tick, METH_VARARGS },
	 { "glk_request_line_event", glkc_request_line_event, METH_VARARGS },
	 { "glk_stream_open_memory", glkc_stream_open_memory, METH_VARARGS },
	 { "delete_buffer_t", _wrap_delete_buffer_t, METH_VARARGS },
	 { "get_buffer_maxlen", _wrap_get_buffer_maxlen, METH_VARARGS },
	 { "snapshot_buffer", _wrap_snapshot_buffer, METH_VARARGS },
	 { "snapshot_whole_buffer", _wrap_snapshot_whole_buffer, METH_VARARGS },
	 { "new_buffer_t", _wrap_new_buffer_t, METH_VARARGS },
	 { "glk_get_buffer_stream", glkc_get_buffer_stream, METH_VARARGS },
	 { "glk_get_line_stream", glkc_get_line_stream, METH_VARARGS },
	 { "glk_stream_close", glkc_stream_close, METH_VARARGS },
	 { "glk_window_close", glkc_window_close, METH_VARARGS },
	 { "glk_gestalt_ext", glkc_gestalt_ext, METH_VARARGS },
	 { "glk_exit", glkc_exit, METH_VARARGS },
	 { "delete_schannel_t", _wrap_delete_schannel_t, METH_VARARGS },
	 { "new_schannel_t", _wrap_new_schannel_t, METH_VARARGS },
	 { "delete_fileref_t", _wrap_delete_fileref_t, METH_VARARGS },
	 { "new_fileref_t", _wrap_new_fileref_t, METH_VARARGS },
	 { "delete_stream_t", _wrap_delete_stream_t, METH_VARARGS },
	 { "new_stream_t", _wrap_new_stream_t, METH_VARARGS },
	 { "delete_window_t", _wrap_delete_window_t, METH_VARARGS },
	 { "new_window_t", _wrap_new_window_t, METH_VARARGS },
	 { "delete_event_t", _wrap_delete_event_t, METH_VARARGS },
	 { "new_event_t", _wrap_new_event_t, METH_VARARGS },
	 { NULL, NULL }
};
#ifdef __cplusplus
}
#endif
/*
 * This table is used by the pointer type-checker
 */
static struct { char *n1; char *n2; void *(*pcnv)(void *); } _swig_mapping[] = {
    { "_signed_long","_glsi32",0},
    { "_signed_long","_long",0},
    { "_glsi32","_signed_long",0},
    { "_glsi32","_long",0},
    { "_stream_t_p","_strid_t",0},
    { "_frefid_t","_fileref_t_p",0},
    { "_stream_result_t","_struct_stream_result_struct",0},
    { "_stream_result_t","_stream_result_struct",0},
    { "_struct_glk_schannel_struct","_schannel_t",0},
    { "_long","_glsi32",0},
    { "_long","_glui32",0},
    { "_long","_unsigned_long",0},
    { "_long","_signed_long",0},
    { "_window_t_p","_winid_t",0},
    { "_strid_t","_stream_t_p",0},
    { "_struct_glk_stream_struct","_stream_t",0},
    { "_glui32","_unsigned_long",0},
    { "_glui32","_long",0},
    { "_unsigned_long","_glui32",0},
    { "_unsigned_long","_long",0},
    { "_struct_stream_result_struct","_stream_result_t",0},
    { "_struct_stream_result_struct","_stream_result_struct",0},
    { "_signed_int","_int",0},
    { "_unsigned_short","_short",0},
    { "_fileref_t","_struct_glk_fileref_struct",0},
    { "_window_t","_struct_glk_window_struct",0},
    { "_signed_short","_short",0},
    { "_schanid_t","_schannel_t_p",0},
    { "_unsigned_int","_int",0},
    { "_short","_unsigned_short",0},
    { "_short","_signed_short",0},
    { "_schannel_t_p","_schanid_t",0},
    { "_struct_event_struct","_event_t",0},
    { "_struct_event_struct","_event_struct",0},
    { "_stream_result_struct","_stream_result_t",0},
    { "_stream_result_struct","_struct_stream_result_struct",0},
    { "_int","_unsigned_int",0},
    { "_int","_signed_int",0},
    { "_stream_t","_struct_glk_stream_struct",0},
    { "_event_struct","_event_t",0},
    { "_event_struct","_struct_event_struct",0},
    { "_fileref_t_p","_frefid_t",0},
    { "_struct_glk_fileref_struct","_fileref_t",0},
    { "_struct_glk_window_struct","_window_t",0},
    { "_winid_t","_window_t_p",0},
    { "_event_t","_struct_event_struct",0},
    { "_event_t","_event_struct",0},
    { "_schannel_t","_struct_glk_schannel_struct",0},
{0,0,0}};

static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void) initglkc() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("glkc", glkcMethods);
	 d = PyModule_GetDict(m);
	 PyDict_SetItemString(d,"gestalt_Version", PyInt_FromLong((long) (0)));
	 PyDict_SetItemString(d,"gestalt_CharInput", PyInt_FromLong((long) (1)));
	 PyDict_SetItemString(d,"gestalt_LineInput", PyInt_FromLong((long) (2)));
	 PyDict_SetItemString(d,"gestalt_CharOutput", PyInt_FromLong((long) (3)));
	 PyDict_SetItemString(d,"gestalt_CharOutput_CannotPrint", PyInt_FromLong((long) (0)));
	 PyDict_SetItemString(d,"gestalt_CharOutput_ApproxPrint", PyInt_FromLong((long) (1)));
	 PyDict_SetItemString(d,"gestalt_CharOutput_ExactPrint", PyInt_FromLong((long) (2)));
	 PyDict_SetItemString(d,"gestalt_MouseInput", PyInt_FromLong((long) (4)));
	 PyDict_SetItemString(d,"gestalt_Timer", PyInt_FromLong((long) (5)));
	 PyDict_SetItemString(d,"gestalt_Graphics", PyInt_FromLong((long) (6)));
	 PyDict_SetItemString(d,"gestalt_DrawImage", PyInt_FromLong((long) (7)));
	 PyDict_SetItemString(d,"gestalt_Sound", PyInt_FromLong((long) (8)));
	 PyDict_SetItemString(d,"gestalt_SoundVolume", PyInt_FromLong((long) (9)));
	 PyDict_SetItemString(d,"gestalt_SoundNotify", PyInt_FromLong((long) (10)));
	 PyDict_SetItemString(d,"gestalt_Hyperlinks", PyInt_FromLong((long) (11)));
	 PyDict_SetItemString(d,"gestalt_HyperlinkInput", PyInt_FromLong((long) (12)));
	 PyDict_SetItemString(d,"gestalt_SoundMusic", PyInt_FromLong((long) (13)));
	 PyDict_SetItemString(d,"gestalt_GraphicsTransparency", PyInt_FromLong((long) (14)));
	 PyDict_SetItemString(d,"evtype_None", PyInt_FromLong((long) (0)));
	 PyDict_SetItemString(d,"evtype_Timer", PyInt_FromLong((long) (1)));
	 PyDict_SetItemString(d,"evtype_CharInput", PyInt_FromLong((long) (2)));
	 PyDict_SetItemString(d,"evtype_LineInput", PyInt_FromLong((long) (3)));
	 PyDict_SetItemString(d,"evtype_MouseInput", PyInt_FromLong((long) (4)));
	 PyDict_SetItemString(d,"evtype_Arrange", PyInt_FromLong((long) (5)));
	 PyDict_SetItemString(d,"evtype_Redraw", PyInt_FromLong((long) (6)));
	 PyDict_SetItemString(d,"evtype_SoundNotify", PyInt_FromLong((long) (7)));
	 PyDict_SetItemString(d,"evtype_Hyperlink", PyInt_FromLong((long) (8)));
	 PyDict_SetItemString(d,"keycode_Unknown", PyInt_FromLong((long) (0xffffffff)));
	 PyDict_SetItemString(d,"keycode_Left", PyInt_FromLong((long) (0xfffffffe)));
	 PyDict_SetItemString(d,"keycode_Right", PyInt_FromLong((long) (0xfffffffd)));
	 PyDict_SetItemString(d,"keycode_Up", PyInt_FromLong((long) (0xfffffffc)));
	 PyDict_SetItemString(d,"keycode_Down", PyInt_FromLong((long) (0xfffffffb)));
	 PyDict_SetItemString(d,"keycode_Return", PyInt_FromLong((long) (0xfffffffa)));
	 PyDict_SetItemString(d,"keycode_Delete", PyInt_FromLong((long) (0xfffffff9)));
	 PyDict_SetItemString(d,"keycode_Escape", PyInt_FromLong((long) (0xfffffff8)));
	 PyDict_SetItemString(d,"keycode_Tab", PyInt_FromLong((long) (0xfffffff7)));
	 PyDict_SetItemString(d,"keycode_PageUp", PyInt_FromLong((long) (0xfffffff6)));
	 PyDict_SetItemString(d,"keycode_PageDown", PyInt_FromLong((long) (0xfffffff5)));
	 PyDict_SetItemString(d,"keycode_Home", PyInt_FromLong((long) (0xfffffff4)));
	 PyDict_SetItemString(d,"keycode_End", PyInt_FromLong((long) (0xfffffff3)));
	 PyDict_SetItemString(d,"keycode_Func1", PyInt_FromLong((long) (0xffffffef)));
	 PyDict_SetItemString(d,"keycode_Func2", PyInt_FromLong((long) (0xffffffee)));
	 PyDict_SetItemString(d,"keycode_Func3", PyInt_FromLong((long) (0xffffffed)));
	 PyDict_SetItemString(d,"keycode_Func4", PyInt_FromLong((long) (0xffffffec)));
	 PyDict_SetItemString(d,"keycode_Func5", PyInt_FromLong((long) (0xffffffeb)));
	 PyDict_SetItemString(d,"keycode_Func6", PyInt_FromLong((long) (0xffffffea)));
	 PyDict_SetItemString(d,"keycode_Func7", PyInt_FromLong((long) (0xffffffe9)));
	 PyDict_SetItemString(d,"keycode_Func8", PyInt_FromLong((long) (0xffffffe8)));
	 PyDict_SetItemString(d,"keycode_Func9", PyInt_FromLong((long) (0xffffffe7)));
	 PyDict_SetItemString(d,"keycode_Func10", PyInt_FromLong((long) (0xffffffe6)));
	 PyDict_SetItemString(d,"keycode_Func11", PyInt_FromLong((long) (0xffffffe5)));
	 PyDict_SetItemString(d,"keycode_Func12", PyInt_FromLong((long) (0xffffffe4)));
	 PyDict_SetItemString(d,"keycode_MAXVAL", PyInt_FromLong((long) (28)));
	 PyDict_SetItemString(d,"style_Normal", PyInt_FromLong((long) (0)));
	 PyDict_SetItemString(d,"style_Emphasized", PyInt_FromLong((long) (1)));
	 PyDict_SetItemString(d,"style_Preformatted", PyInt_FromLong((long) (2)));
	 PyDict_SetItemString(d,"style_Header", PyInt_FromLong((long) (3)));
	 PyDict_SetItemString(d,"style_Subheader", PyInt_FromLong((long) (4)));
	 PyDict_SetItemString(d,"style_Alert", PyInt_FromLong((long) (5)));
	 PyDict_SetItemString(d,"style_Note", PyInt_FromLong((long) (6)));
	 PyDict_SetItemString(d,"style_BlockQuote", PyInt_FromLong((long) (7)));
	 PyDict_SetItemString(d,"style_Input", PyInt_FromLong((long) (8)));
	 PyDict_SetItemString(d,"style_User1", PyInt_FromLong((long) (9)));
	 PyDict_SetItemString(d,"style_User2", PyInt_FromLong((long) (10)));
	 PyDict_SetItemString(d,"style_NUMSTYLES", PyInt_FromLong((long) (11)));
	 PyDict_SetItemString(d,"wintype_AllTypes", PyInt_FromLong((long) (0)));
	 PyDict_SetItemString(d,"wintype_Pair", PyInt_FromLong((long) (1)));
	 PyDict_SetItemString(d,"wintype_Blank", PyInt_FromLong((long) (2)));
	 PyDict_SetItemString(d,"wintype_TextBuffer", PyInt_FromLong((long) (3)));
	 PyDict_SetItemString(d,"wintype_TextGrid", PyInt_FromLong((long) (4)));
	 PyDict_SetItemString(d,"wintype_Graphics", PyInt_FromLong((long) (5)));
	 PyDict_SetItemString(d,"winmethod_Left", PyInt_FromLong((long) (0x00)));
	 PyDict_SetItemString(d,"winmethod_Right", PyInt_FromLong((long) (0x01)));
	 PyDict_SetItemString(d,"winmethod_Above", PyInt_FromLong((long) (0x02)));
	 PyDict_SetItemString(d,"winmethod_Below", PyInt_FromLong((long) (0x03)));
	 PyDict_SetItemString(d,"winmethod_DirMask", PyInt_FromLong((long) (0x0f)));
	 PyDict_SetItemString(d,"winmethod_Fixed", PyInt_FromLong((long) (0x10)));
	 PyDict_SetItemString(d,"winmethod_Proportional", PyInt_FromLong((long) (0x20)));
	 PyDict_SetItemString(d,"winmethod_DivisionMask", PyInt_FromLong((long) (0xf0)));
	 PyDict_SetItemString(d,"fileusage_Data", PyInt_FromLong((long) (0x00)));
	 PyDict_SetItemString(d,"fileusage_SavedGame", PyInt_FromLong((long) (0x01)));
	 PyDict_SetItemString(d,"fileusage_Transcript", PyInt_FromLong((long) (0x02)));
	 PyDict_SetItemString(d,"fileusage_InputRecord", PyInt_FromLong((long) (0x03)));
	 PyDict_SetItemString(d,"fileusage_TypeMask", PyInt_FromLong((long) (0x0f)));
	 PyDict_SetItemString(d,"fileusage_TextMode", PyInt_FromLong((long) (0x100)));
	 PyDict_SetItemString(d,"fileusage_BinaryMode", PyInt_FromLong((long) (0x000)));
	 PyDict_SetItemString(d,"filemode_Write", PyInt_FromLong((long) (0x01)));
	 PyDict_SetItemString(d,"filemode_Read", PyInt_FromLong((long) (0x02)));
	 PyDict_SetItemString(d,"filemode_ReadWrite", PyInt_FromLong((long) (0x03)));
	 PyDict_SetItemString(d,"filemode_WriteAppend", PyInt_FromLong((long) (0x05)));
	 PyDict_SetItemString(d,"seekmode_Start", PyInt_FromLong((long) (0)));
	 PyDict_SetItemString(d,"seekmode_Current", PyInt_FromLong((long) (1)));
	 PyDict_SetItemString(d,"seekmode_End", PyInt_FromLong((long) (2)));
	 PyDict_SetItemString(d,"stylehint_Indentation", PyInt_FromLong((long) (0)));
	 PyDict_SetItemString(d,"stylehint_ParaIndentation", PyInt_FromLong((long) (1)));
	 PyDict_SetItemString(d,"stylehint_Justification", PyInt_FromLong((long) (2)));
	 PyDict_SetItemString(d,"stylehint_Size", PyInt_FromLong((long) (3)));
	 PyDict_SetItemString(d,"stylehint_Weight", PyInt_FromLong((long) (4)));
	 PyDict_SetItemString(d,"stylehint_Oblique", PyInt_FromLong((long) (5)));
	 PyDict_SetItemString(d,"stylehint_Proportional", PyInt_FromLong((long) (6)));
	 PyDict_SetItemString(d,"stylehint_TextColor", PyInt_FromLong((long) (7)));
	 PyDict_SetItemString(d,"stylehint_BackColor", PyInt_FromLong((long) (8)));
	 PyDict_SetItemString(d,"stylehint_ReverseColor", PyInt_FromLong((long) (9)));
	 PyDict_SetItemString(d,"stylehint_NUMHINTS", PyInt_FromLong((long) (10)));
	 PyDict_SetItemString(d,"stylehint_just_LeftFlush", PyInt_FromLong((long) (0)));
	 PyDict_SetItemString(d,"stylehint_just_LeftRight", PyInt_FromLong((long) (1)));
	 PyDict_SetItemString(d,"stylehint_just_Centered", PyInt_FromLong((long) (2)));
	 PyDict_SetItemString(d,"stylehint_just_RightFlush", PyInt_FromLong((long) (3)));
	 PyDict_SetItemString(d,"imagealign_InlineUp", PyInt_FromLong((long) (0x01)));
	 PyDict_SetItemString(d,"imagealign_InlineDown", PyInt_FromLong((long) (0x02)));
	 PyDict_SetItemString(d,"imagealign_InlineCenter", PyInt_FromLong((long) (0x03)));
	 PyDict_SetItemString(d,"imagealign_MarginLeft", PyInt_FromLong((long) (0x04)));
	 PyDict_SetItemString(d,"imagealign_MarginRight", PyInt_FromLong((long) (0x05)));

	ref_llhinit(gBufferRefs);
	buf_llhinit(gSavedBuffers);
	glk_set_interrupt_handler(&callInterruptHandler);
{
   int i;
   for (i = 0; _swig_mapping[i].n1; i++)
        SWIG_RegisterMapping(_swig_mapping[i].n1,_swig_mapping[i].n2,_swig_mapping[i].pcnv);
}
}
