#include <Python.h>

#include <glk.h>
#include <glkstart.h>

int gArgC = 0;
char ** gArgV = NULL;

glkunix_argumentlist_t glkunix_arguments[] = {
    { "-", glkunix_arg_ValueFollows, "-: pass the next arg to Python" },
    { NULL, glkunix_arg_End, NULL }
};

int glkunix_startup_code(glkunix_startup_t *data)
{
    int i;

    gArgV = (char **) malloc(data->argc * sizeof(char *));
	gArgV[0] = data->argv[0]; 
    gArgC = 1;
    for (i = gArgC; i < data->argc; i++) {
        if (strcmp(data->argv[i], "-") == 0) {
            i++;
            gArgV[gArgC] = data->argv[i];
            gArgC++;
        }
    } 

    return TRUE;
}

void cleanup_pyglk(void)
{
    Py_Finalize();
    if (gArgV != NULL) {
        free(gArgV);
        gArgV = NULL;
    }
}

void glk_main(void)
{
    int result;

    Py_Initialize();
    glk_set_interrupt_handler(&cleanup_pyglk);
    result = Py_Main(gArgC, gArgV);
    cleanup_pyglk();
}
