!----------------------------------------------------------------------------
!                           VARIABLES AND STUFF

global CENTER_MAP_HORZ
global CENTER_MAP_VERT
property map_list     
global iterating
global mapping_door
array from_array[8]
global AUTOMAP_ON

!---------------------------------------------------------------------------
!                               THE ROUTINES

routine FullMap(from)
{
  local home_loc, z, tot, connex, neighbor, sw1

  from = Map(from, true)
  home_loc = from
  from.map_list#13 = true

  for (z = 5; z <= 12; z++)
  {
    if from.map_list#z and from.map_list#z ~= from
    {
      from_array[tot] = from.map_list#z
      from_array[tot].map_list#3 = from
      tot++
    }
  }

  iterating = true
  for (z = 5; z <= 12; z++)
  {
    if from.map_list#z ~= 0 and from.map_list#z ~= from
    {
      connex = from.map_list#z                   
      CENTER_MAP_HORZ = connex.map_list#1
      CENTER_MAP_VERT = connex.map_list#2
      iterating = true
      Map(connex, true)
      connex.map_list#13 = true                 
    }
  }

:IterateHome

  tot--
  from = from_array[tot]

:IterateNeighbor

  if from = home_loc
    jump IterateHome
  sw1 = false
  
  for (z = 5; z <= 12; z++)
  {
    if from.map_list#z and from.map_list#z ~= from
    {
      neighbor = from.map_list#z

      if neighbor ~= from.map_list#3 and
         neighbor.map_list#4 = 0 and 
         neighbor.map_list#13 = 0
      {
        neighbor.map_list#3 = from
        CENTER_MAP_HORZ = neighbor.map_list#1
        CENTER_MAP_VERT = neighbor.map_list#2
        iterating = true
        Map(neighbor, true)
        neighbor.map_list#13 = true
        sw1 = true
        from = neighbor
        break
      }
    }
  }

  if sw1
    jump IterateNeighbor

  from.map_list#4 = true                        
  from = from.map_list#3

  if from = home_loc, 0
  {
    if tot <= 0
    {
      color BGCOLOR, TEXTCOLOR
      locate (home_loc.map_list#1), (home_loc.map_list#2)
      if home_loc.u_to : print "\Bu\b"; : else : print "\B*\b";
      if home_loc.d_to : print "\Bd\b"; : else : print "\B*\b";
      if home_loc.in_to : print "\Bi\b"; : else : print "\B*\b";
      if home_loc.out_to : print "\Bo\b"; : else : print "\B*\b";
      locate 1, 1
      color TEXTCOLOR, BGCOLOR
      iterating = false

      for (z = 1; z <= objects; z++)
      {
        if z.type = room
        {
          z.map_list#4 = 0
          z.map_list#13 = 0
        }
        if z <= 8
          from_array[z] = 0
      }
      locate 11, 1
      "done"

      return from
    }
    else
    {
      jump IterateNeighbor
    }
  }
  else
  { if from = home_loc
      jump IterateHome 
    else
      jump IterateNeighbor
  }
}


routine Map(from, full)
{
  local dir, a, g, startpos, startrow, neighbor

  Font(PROP_OFF)  

  if not iterating
  { if not from or from.type ~= room
      from = location
    if from is not visited or not FindLight(from)
    { "You wish."
      return false
    }
  if verbroutine ~= &DoWait, &DoWaitUntil
    ""
  }

  mapping_door = from                               ! door-handling switch

  if not iterating
  {
    if not full
    {
      CENTER_MAP_HORZ = display.linelength - 10             
      CENTER_MAP_VERT = 4             
      color BGCOLOR, TEXTCOLOR
      startpos = CENTER_MAP_HORZ - 7
      startrow = CENTER_MAP_VERT - 3

      for (a=1; a<=7; a++)
      { locate startpos, startrow
        print to (CENTER_MAP_HORZ + 10)
        startrow += 1
      }
    }
    else
    {
      CENTER_MAP_HORZ = display.linelength / 2 - 3
      CENTER_MAP_VERT = display.windowlines / 2
      from.map_list#1 = CENTER_MAP_HORZ
      from.map_list#2 = CENTER_MAP_VERT
      cls
      locate 1, 1
      print "mapping...";
    }
  }

  for (dir=0; dir<=11; dir++)
  {
    select dir
      case 0
      { if from.nw_to
        { startpos = CENTER_MAP_HORZ - 5
          startrow = CENTER_MAP_VERT - 2
          neighbor = from.nw_to
          from.map_list#5 = neighbor
        }
      }
      case 1
      { if from.n_to
        { startpos = CENTER_MAP_HORZ
          startrow = CENTER_MAP_VERT - 2
          neighbor = from.n_to
          from.map_list#6 = neighbor
        }
      }
      case 2
      { if from.ne_to
        { startpos = CENTER_MAP_HORZ + 5
          startrow = CENTER_MAP_VERT - 2
          neighbor = from.ne_to
          from.map_list#7 = neighbor
        }
      }
      case 3
      { if from.w_to
        { startpos = CENTER_MAP_HORZ - 5
          startrow = CENTER_MAP_VERT
          neighbor = from.w_to
          from.map_list#8 = neighbor
        }
      }
      case 4
      { if not full
          color TEXTCOLOR, BGCOLOR
        else
          color BGCOLOR, TEXTCOLOR
        locate CENTER_MAP_HORZ, CENTER_MAP_VERT
        if not iterating and from is visited and
           CENTER_MAP_HORZ >= 1 and CENTER_MAP_HORZ <= display.linelength and
           CENTER_MAP_VERT >= 1 and CENTER_MAP_VERT <= (display.windowlines - 2)
        { if from.u_to and not full
            print "\Bu\b";
          elseif from.u_to and full
            print "u";
          else
            print "\B*\b";
        }
        neighbor = -1
      }
      case 5
      { locate (CENTER_MAP_HORZ + 1), CENTER_MAP_VERT
        if from is visited and
           CENTER_MAP_HORZ >= 1 and CENTER_MAP_HORZ <= display.linelength and
           CENTER_MAP_VERT >= 1 and CENTER_MAP_VERT <= (display.windowlines - 2)
        { if from.d_to and not full
            print "\Bd\b";
          elseif from.d_to and full
            print "d";
          elseif not iterating
            print "\B*\b";
        }
        neighbor = -1
      }
      case 6
      { locate (CENTER_MAP_HORZ + 2), CENTER_MAP_VERT
        if from is visited and
           CENTER_MAP_HORZ >= 1 and CENTER_MAP_HORZ <= display.linelength and
           CENTER_MAP_VERT >= 1 and CENTER_MAP_VERT <= (display.windowlines - 2)
        { if from.in_to and not full
            print "\Bi\b";
          elseif from.in_to and full
            print "i";
          elseif not iterating
            print "\B*\b";
        }
        neighbor = -1
      }
      case 7
      { locate (CENTER_MAP_HORZ + 3), CENTER_MAP_VERT
        if from is visited and
           CENTER_MAP_HORZ >= 1 and CENTER_MAP_HORZ <= display.linelength and
           CENTER_MAP_VERT >= 1 and CENTER_MAP_VERT <= (display.windowlines - 2)
        { if from.out_to and not full
            print "\Bo\b";
          elseif from.out_to and full
            print "o";
          elseif not iterating
            print "\B*\b";
        }
        neighbor = -1
      }
      case 8
      { if not full
          color BGCOLOR, TEXTCOLOR
        else
          color TEXTCOLOR, BGCOLOR
        if from.e_to
        { startpos = CENTER_MAP_HORZ + 5
          startrow = CENTER_MAP_VERT
          neighbor = from.e_to
          from.map_list#9 = neighbor
        }
      }
      case 9
      { if from.sw_to
        { startpos = CENTER_MAP_HORZ - 5
          startrow = CENTER_MAP_VERT + 2
          neighbor = from.sw_to
          from.map_list#10 = neighbor
        }
      }
      case 10
      { if from.s_to
        { startpos = CENTER_MAP_HORZ
          startrow = CENTER_MAP_VERT + 2
          neighbor = from.s_to
          from.map_list#11 = neighbor
        }
      }
      case 11
      { if from.se_to
        { startpos = CENTER_MAP_HORZ + 5
          startrow = CENTER_MAP_VERT + 2
          neighbor = from.se_to
          from.map_list#12 = neighbor
        }
      }

    if neighbor ~= 0, -1                     ! and not iterating
    { if neighbor ~= from
      { neighbor.map_list#1 = startpos
        neighbor.map_list#2 = startrow
        DrawMapLoc(neighbor, startpos, startrow, full)
      }
    }

  locate 1,1
  }

  if from.nw_to and from is visited
  {
    locate (CENTER_MAP_HORZ - 1), (CENTER_MAP_VERT -1)
    if (CENTER_MAP_HORZ - 1) >= 1 and (CENTER_MAP_HORZ - 1) <= display.linelength and
       (CENTER_MAP_VERT - 1) >= 1 and (CENTER_MAP_VERT - 1) <= (display.windowlines-2)
    { if from.w_to                         
      { g = from.w_to                     
        if g.ne_to and g is visited and g ~= from
          print "X";
        else
          print "\\\_";
      }
      elseif from.n_to
      { g = from.n_to
        if g.sw_to and g is visited and g ~= from
          print "X";
        else
          print "\\\_";
      }
      else
        print "\\\_";
    }
    locate 1,1
  }
  if from.n_to and from is visited
  {
    locate (CENTER_MAP_HORZ + 2), (CENTER_MAP_VERT - 1)
    if (CENTER_MAP_HORZ + 2) >= 1 and (CENTER_MAP_HORZ + 2) <= display.linelength and
       (CENTER_MAP_VERT - 1) >= 1 and (CENTER_MAP_VERT - 1) <= (display.windowlines-2)
    { print "|";
    }
    locate 1,1
  }
  if from.ne_to and from is visited
  { locate (CENTER_MAP_HORZ + 4), (CENTER_MAP_VERT - 1)
    if (CENTER_MAP_HORZ + 4) >= 1 and (CENTER_MAP_HORZ + 4) <= display.linelength and
       (CENTER_MAP_VERT - 1) >= 1 and (CENTER_MAP_VERT - 1) <= (display.windowlines-2)
    { if from.e_to
      { g = from.e_to
        if g.nw_to and g is visited and g ~= from
          print "X";
        else
          print "/";
      }
      elseif from.n_to 
      { g = from.n_to
        if g.se_to and g is visited and g ~= from
          print "X";
        else
          print "/";
      }
      else
        print "/";
    }
    locate 1,1
  }
  if from.w_to and from is visited
  { locate (CENTER_MAP_HORZ - 1), CENTER_MAP_VERT
    if (CENTER_MAP_HORZ - 1) >= 1 and (CENTER_MAP_HORZ - 1) <= display.linelength and
       (CENTER_MAP_VERT) >= 1 and (CENTER_MAP_VERT) <= (display.windowlines-2)
    { print "-";
    }
    locate 1,1
  }
  if from.e_to and from is visited
  { locate (CENTER_MAP_HORZ + 4), CENTER_MAP_VERT
    if (CENTER_MAP_HORZ + 4) >= 1 and (CENTER_MAP_HORZ + 4) <= display.linelength and
       (CENTER_MAP_VERT) >= 1 and (CENTER_MAP_VERT) <= (display.windowlines-2)
    { print "-";
    }
    locate 1,1
  }
  if from.sw_to and from is visited
  { locate (CENTER_MAP_HORZ - 1), (CENTER_MAP_VERT + 1)
    if (CENTER_MAP_HORZ - 1) >= 1 and (CENTER_MAP_HORZ - 1) <= display.linelength and
       (CENTER_MAP_VERT + 1) >= 1 and (CENTER_MAP_VERT + 1) <= (display.windowlines-2)
    { if from.w_to
      { g = from.w_to
        if g.se_to and g is visited and g ~= from
          print "X";
        else
          print "/";
      }
      elseif from.s_to
      { g = from.s_to
        if g.nw_to and g is visited and g ~= from
          print "X";
        else
          print "/";
      }
      else
        print "/";
    }
    locate 1,1
  }
  if from.s_to and from is visited
  { locate (CENTER_MAP_HORZ + 2), (CENTER_MAP_VERT + 1)
    if (CENTER_MAP_HORZ + 2) >= 1 and (CENTER_MAP_HORZ + 2) <= display.linelength and
       (CENTER_MAP_VERT + 1) >= 1 and (CENTER_MAP_VERT + 1) <= (display.windowlines-2)
    { print "|";
    }
    locate 1,1
  }
  if from.se_to and from is visited
  { locate (CENTER_MAP_HORZ + 4), (CENTER_MAP_VERT + 1)
    if (CENTER_MAP_HORZ + 4) >= 1 and (CENTER_MAP_HORZ + 4) <= display.linelength and
       (CENTER_MAP_VERT + 1) >= 1 and (CENTER_MAP_VERT + 1) <= (display.windowlines-2)
    { if from.e_to
      { g = from.e_to
        if g.sw_to and g is visited and g ~= from
          print "X";
        else
          print "\\\_";
      }
      elseif from.s_to 
      { g = from.s_to
        if g.ne_to and g is visited and g ~= from
          print "X";
        else
          print "\\\_";
      }
      else
        print "\\\_";
    }
    locate 1,1
  }

  mapping_door = false
  color TEXTCOLOR, BGCOLOR
  Font(DEFAULT_FONT)
  return from
}


routine DrawMapLoc(loc, startpos, startrow, full)
{
  local dir

  if loc is not visited
    return false

  for (dir=0; dir<=11; dir++)
  {
    select dir
      case 0
      { if loc.nw_to
        { locate (startpos - 1), (startrow -1)
          if (startpos - 1) >= 1 and (startpos - 1) <= display.linelength and
             (startrow - 1) >= 1 and (startrow - 1) <= (display.windowlines-2)
          { print "\\\_";
          }
        }
      }
      case 1
      { if loc.n_to
        { locate (startpos + 2), (startrow - 1)
          if (startpos + 2) >= 1 and (startpos + 2) <= display.linelength and
             (startrow - 1) >= 1 and (startrow - 1) <= (display.windowlines-2)
          { print "|";
          }
        }
      }
      case 2
      { if loc.ne_to
        { locate (startpos + 4), (startrow - 1)
          if (startpos + 4) >= 1 and (startpos + 4) <= display.linelength and
             (startrow - 1) >= 1 and (startrow - 1) <= (display.windowlines-2)
          { print "/";
          }
        }
      }
      case 3
      { if loc.w_to
        { locate (startpos - 1), startrow
          if (startpos - 1) >= 1 and (startpos - 1) <= display.linelength and
             (startrow) >= 1 and (startrow) <= (display.windowlines-2)
          { print "-";
          }
        }
      }
      case 4
      { locate startpos, startrow
        if not full
          color TEXTCOLOR, BGCOLOR
        else
          color BGCOLOR, TEXTCOLOR
        if (startpos) >= 1 and (startpos) <= display.linelength and
           (startrow) >= 1 and (startrow) <= (display.windowlines-2)
        { if loc.u_to : print "u";
          else        : print " ";
        }
      }
      case 5
      { locate (startpos + 1), startrow
        if (startpos + 1) >= 1 and (startpos + 1) <= display.linelength and
           (startrow) >= 1 and (startrow) <= (display.windowlines-2)
        { if loc.d_to : print "d";
          else        : print " ";
        }
      }
      case 6
      { locate (startpos + 2), startrow
        if (startpos + 2) >= 1 and (startpos + 2) <= display.linelength and
           (startrow) >= 1 and (startrow) <= (display.windowlines-2)
        { if loc.in_to : print "i";
          else         : print " ";
        }
      }
      case 7
      { locate (startpos + 3), startrow
        if (startpos + 3) >= 1 and (startpos + 3) <= display.linelength and
           (startrow) >= 1 and (startrow) <= (display.windowlines-2)
        { if loc.out_to : print "o";
          else          : print " ";
        }
      }
      case 8
      { if not full
          color BGCOLOR, TEXTCOLOR
        else
          color TEXTCOLOR, BGCOLOR
        if loc.e_to
        { locate (startpos + 4), startrow
          if (startpos + 4) >= 1 and (startpos + 4) <= display.linelength and
             (startrow) >= 1 and (startrow) <= (display.windowlines-2)
          { print "-";
          }
        }
      }
      case 9
      { if loc.sw_to
        { locate (startpos - 1), (startrow + 1)
          if (startpos - 1) >= 1 and (startpos - 1) <= display.linelength and
             (startrow + 1) >= 1 and (startrow + 1) <= (display.windowlines-2)
          { print "/";
          }
        }
      }
      case 10
      { if loc.s_to
        { locate (startpos + 2), (startrow + 1)
          if (startpos + 2) >= 1 and (startpos + 2) <= display.linelength and
             (startrow + 1) >= 1 and (startrow + 1) <= (display.windowlines-2)
          { print "|";
          }
        }
      }
      case 11
      { if loc.se_to
        { locate (startpos + 4), (startrow + 1)
          if (startpos + 4) >= 1 and (startpos + 4) <= display.linelength and
             (startrow + 1) >= 1 and (startrow + 1) <= (display.windowlines-2)
          { print "\\\_";
          }
        }
      }
  locate 1,1
  }
  return loc
}

!----------------------------------------------------------------------------
!                           REPLACEMENT PREPARSE()

replace PreParse
{
  local a, b
  for (a = n_obj; a <= out_obj; a++)
  {
    for (b = 1; b <= a.#nouns; b++)
    {
      if a.nouns#b = word[1] and word[2] = ""
      {
        word[2] = word[1]
        word[1] = "go"
        return true
      }
    }
  }
  return false
}

!----------------------------------------------------------------------------
!                     REPLACEMENT DOOR CLASS DEFINITION

replace door "door"
{
	type door
	door_to                            ! depends on actor location
	{
		local currentroom
                if actor = player and not mapping_door
			currentroom = location
                elseif not mapping_door
			currentroom = parent(actor)
                else
                        currentroom = mapping_door
			
              if not mapping_door           ! begin if not mapping_door
              {
                ! sitting on or in something
#ifclear USE_VEHICLES
		if actor = player and player not in location
#endif
#ifset USE_VEHICLES
		if actor = player and player not in location and
			parent(player).type ~= vehicle:
#endif
		{
			! "You'll have to get out first..."
			OMessage(door, 1)
			return true
		}

		if self is not open and actor = player
		{
#ifclear NO_VERBS
			if verbroutine = &DoGo and self is not locked and
				self is openable:
			{
				OMessage(door, 2)       ! "(opening it first)"
				Perform(&DoOpen, self)
!                                main    ! counts as a turn
				if self is not open
					return false
			}
			elseif verbroutine = &DoGo and self is lockable
				{OMessage(door, 3)      ! "It is locked."
				return true}
			else
			{
#endif
				OMessage(door, 4)       ! "It is closed."
				return true
#ifclear NO_VERBS
			}
#endif
		}

		if self is not open and (actor in location or 
			location = self.between #((parent(actor) = \
				self.between #1) + 1))
		{
			! Notify the player that the player or a character
			! has gone through the door:
			!
			OMessage(door, 5)       
			general = 2
		}
              }                                 ! end if not mapping_door
		if currentroom = self.between #1
			return self.between #2
		else
			return self.between #1
	}
	long_desc
	{
		if self is open
			OMessage(door, 6)       ! when open
		else
			OMessage(door, 7)       ! when closed
	}
	is openable, static
}

replace DoWait(count)                   ! count argument is from DoWaitUntil
{
	if object = 0
		count = 3
	elseif count = 0
		count = object
	
	Message(&DoWait)                ! "Time passes..."
        if AUTOMAP_ON
          ""
	event_flag = 0
	while --count
	{
		main
		if event_flag
			if not KeepWaiting
				return
	}
	event_flag = 0
	return true
}

!----------------------------------------------------------------------------
!                           REPLACEMENT PREPARSE()

replace PreParse
{
  local a, b
  for (a = n_obj; a <= out_obj; a++)
  {
    for (b = 1; b <= a.#nouns; b++)
    {
      if a.nouns#b = word[1] and word[2] = ""
      {
        word[2] = word[1]
        word[1] = "go"
        return false
      }
    }
  }
  return false
}

!----------------------------------------------------------------------------
!                     REPLACEMENT DOOR CLASS DEFINITION

replace door "door"
{
	type door
	door_to                            ! depends on actor location
	{
		local currentroom
                if actor = player and not mapping_door
			currentroom = location
                elseif not mapping_door
			currentroom = parent(actor)
                else
                        currentroom = mapping_door
			
              if not mapping_door          ! begin if not mapping_door
              {
                ! sitting on or in something
#ifclear USE_VEHICLES
		if actor = player and player not in location
#endif
#ifset USE_VEHICLES
		if actor = player and player not in location and
			parent(player).type ~= vehicle:
#endif
		{
			! "You'll have to get out first..."
			OMessage(door, 1)
			return true
		}

                if self is not open and actor = player
		{
#ifclear NO_VERBS
                        if verbroutine = &DoGo and self is not locked and
                                self is openable:
			{
				OMessage(door, 2)       ! "(opening it first)"
                                Perform(&DoOpen, self)
!                                main    ! counts as a turn
                                if self is not open
					return false
			}
                        elseif verbroutine = &DoGo and self is lockable
				{OMessage(door, 3)      ! "It is locked."
				return true}
                        else
			{
#endif
				OMessage(door, 4)       ! "It is closed."
                                return true
#ifclear NO_VERBS
			}
#endif
		}

                if self is not open and (actor in location or 
                        location = self.between #((parent(actor) = \
                                self.between #1) + 1))
		{
			! Notify the player that the player or a character
			! has gone through the door:
			!
			OMessage(door, 5)       
			general = 2
		}
              }                                 ! end if not mapping_door
                if currentroom = self.between #1
                        return self.between #2
		else
                        return self.between #1
	}
	long_desc
	{
                if self is open
			OMessage(door, 6)       ! when open
		else
			OMessage(door, 7)       ! when closed
	}
	is openable, static
}

replace DoWait(count)                   ! count argument is from DoWaitUntil
{
	if object = 0
		count = 3
	elseif count = 0
		count = object
	
	Message(&DoWait)                ! "Time passes..."
        if AUTOMAP_ON
          ""
	event_flag = 0
	while --count
	{
		main
		if event_flag
			if not KeepWaiting
				return
	}
	event_flag = 0
	return true
}

