/*
	HCQUICKC.C

	Non-portable functions specific to QuickC/MS-DOS:

		hugo_splitpath
		hugo_makepath
		hugo_closefiles

	for the Hugo Compiler

	Copyright (c) 1995-2006 by Kent Tessman

	NOTE:  Generally, any functions with names such as _function()
	are QuickC library calls.  In most cases it may be preferable to
	use the appropriate call from the particular compiler library;
	if none is available, it may be necessary to write a brief routine
	that accomplishes the same result.
*/


#include "hcheader.h"


/*
    FILENAME MANAGEMENT:

    Different operating systems will have their own ways of naming
    files.  The following routines are simply required to know and
    be able to dissect/build the components of a particular filename,
    storing/restoring the components via the specified char arrays.

    For example, in MS-DOS:

    	hugo_splitpath("C:\HUGO\FILES\HUGOLIB.H", ...)
        	becomes:  C:, HUGO\FILES, HUGOLIB, H

    and

    	hugo_makepath(..., "C:", "HUGO\FILES", "HUGOLIB", "H")
		becomes:  C:\HUGO\FILES\HUGOLIB.H

    The appropriate equivalent nomenclature should be used for the
    operating system in question.
*/

void hugo_splitpath(char *path, char *drive, char *dir, char *fname, char *ext)
{
	_splitpath(path, drive, dir, fname, ext);
}

void hugo_makepath(char *path, char *drive, char *dir, char *fname, char *ext)
{
	_makepath(path, drive, dir, fname, ext);
}


/* hugo_closefiles

    Closes all open files.  NOTE:  If the operating system automatically
    closes any open streams upon exit from the program, this function may
    be left empty.
*/

void hugo_closefiles()
{
	fcloseall();			/* non-ANSI function */
/*
	fclose(sourcefile);
	fclose(objectfile);
	fclose(textfile);
	fclose(allfile);
	fclose(listfile);
*/
}
