/*---------------------------------------------------------------------------**
**
**
** File: CYOA_LIB
**
** Author: Mark J. Musante
**
** Revision History:
**
**	1998-Feb-09	Added 'restart' command.
**
**	1998-Jan-25	Added 'save' and 'restore' commands.
**
**	1998-Jan-22	Added 'undo' command.
**
**	1998-Jan-20	CYOA_initial CYOA_version.
**
**
**---------------------------------------------------------------------------*/

/*

//
// These defCYOA_initions are required by the compiler, but are not
// used in this game.
//
takeVerb: object;
strObj: object;
numObj: object;
againVerb: object;
pardon: object;

*/


// "CYOA_Me" is used by the runtime to determine the left-hand side
// of the status line. Whatever is in 'CYOA_Me.location.statusLine' 
// appears up there.
CYOA_Me: object
	sdesc = "myself"
	roomCheck( v ) = {
		return true;
	}
;

//
// This is the startup code
//
CYOA_init: function
{
        if (systemInfo(__SYSINFO_SYSINFO) = true
            and systemInfo(__SYSINFO_HTML) = 1)
	{
		"\H+"; CYOA_global.html_mode := true;
	}
	"\b\b";
	intro.desc;
	"\b";
	CYOA_version.desc;
	"\b\t";

	CYOA_Me.location := startplace;

	CYOA_Me.location.desc;
}

//
// Some CYOA_global definitions.
//
CYOA_global: object
	html_mode = nil
	
	// ary is used by the choiceVerb class. Don't change it without
	// changing choiceVerb.action() as well
	ary = [ &choice1, &choice2, &choice3,
	        &choice4, &choice5, &choice6,
		&choice7, &choice8, &choice9 ]
	
	// change death_msg before calling CYOA_die; if you want some
	// other message than 'You have died'
	death_msg = 'died'
	
	// if you want to change the propmt, change this
	prompt = '>'
	// this is the value that gets passed to CYOA_initRestart when the user
	// requests a restart
	CYOA_initRestartParam = 0


	// this is set to true in the default CYOA_initRestart function
	restarting = nil
;

Place: object
	statusRoot = "Wandering"
	desc = "* NO DESCRIPTION DEFINED *"
	choices = "\t* NO CHOICES DEFINED *"
	choice1 = nil
	choice2 = nil
	choice3 = nil
	choice4 = nil
	choice5 = nil
	choice6 = nil
	choice7 = nil
	choice8 = nil
	choice9 = nil
    statusLine =
    {
        /*
         *   Check the system to see if this is an HTML-enabled run-time.
         *   If so, generate an HTML-style banner; otherwise, generate an
         *   old-style banner. 
         */
        if (CYOA_global.html_mode)
        { 
		"<banner id=StatusLine height=previous border>
            <body bgcolor=\"#9999FF\" text=statustext>";
            "<b>"; self.statusRoot; "</b>";
		"<tab align=right>";
		"<i>"; self.author; " </i></banner>";
        }
        else
        {
            self.statusRoot;
        }
    }
;

/* 'modify' this object in your source code.
**
** Sample:
**	modify intro
**		desc = "Here's a really cool introduction to my game. "
**	;
*/
intro: object
	desc = "(*) CREATE AN OBJECT NAMED 'intro' AND GIVE IT A 'desc'
		PROPERTY. "
;

/* 'modify' this object in your source code
**
** Sample:
**	modify CYOA_version
**		desc = "The Cool Game, Serial Number 050123, Release 6. ";
**	;
*/
CYOA_version: object
	desc = "A Work of Fiction, created with TADS (the Text Adventure
		Development System) in conjunction with the CYOA_LIB by
		Mark J.\ Musante. "
;

/* 'modify' this object in your source code. This is the message that is
** displayed after the user decides to quit.
*/
endgame: object
	desc = "Thanks for playing!\b"
;

CYOA_die: function
{
	local response;

	"\b\t* * * You have <<CYOA_global.death_msg>>. * * *\b";

	while( 1 ) {
		"Would you like to (R)estart, Re(s)tore, (U)ndo, or (Q)uit? ";

		response := lower(input());
		if ( response = 's' || response = 'restore' ) {
			response := askfile( 'File to restore' );
			if ( response = nil )
				"Restore failed. ";
			else if ( restore( response ) )
				"Restore failed. ";
			else
				return;
		} else if ( response = 'r' || response = 'restart' ) {
			restart();
			return;
		} else if ( response = 'u' || response = 'undo' ) {
			if ( undo() ) {
				"(Undoing one command)\b\t";
				CYOA_Me.location.desc;
				return;
			} else {
				"No undo information available. ";
			}
		} else {
			endgame.desc;
			quit();
		}
	}
}

/*

//
// Here's where we give some basic advice.
//
parseError: function( err, str )
{
	if ( err = 2 )
		return 'I don\'t understand that command. For a list of ' +
			'valid comands, please type \'help\'.';
	else
		return nil;
}

//
// This function allows us to convert the command line into a word
// that the TADS parser will allow us to handle.
//
preparse: function( str )
{
	local foo;

	if ( str = '' ) {
		"Pardon me? ";
		return nil;
	}

	foo := cvtnum( str );
	switch( foo ) {
	case 1: return 'one';
	case 2: return 'two';
	case 3: return 'three';
	case 4: return 'four';
	case 5: return 'five';
	case 6: return 'six';
	case 7: return 'seven';
	case 8: return 'eight';
	case 9: return 'nine';
	default:
		if ( foo < 0 || foo > 9 || str = '0' ) {
			"Enter a choice from the menu, please. ";
			return nil;
		}
		return true;
	}
}

//
// only allow one entry per command line
//
preparseCmd: function( list )
{
	local foo := [];

	if ( length( list ) = 1 )
		return true;
	else {
		foo += list[ 1 ];
		return foo;
	}
}

//
// Here's where we display the choice list & give the player the prompt
//
commandPrompt: function( type )
{
	if ( type = 0 || type = 1 ) {
		"\bWhat would you like to do?\b";
		CYOA_Me.location.choices;
		"\b";
		say( CYOA_global.prompt );
	} else {
		">";
	}
}

*/


//
// Basic choices.  Numbered 1 through 9.
//
choiceVerb: object
	num = 0
	action( actor ) = {
		local newloc;
		
		if ( self.num = 0 ) {
			"Parse error: number not set in verb.\n";
			abort;
		}

		if ( self.num < 1 || self.num > 9 ) {
			"Parse error: choice out of range.\b";
			abort;
		}

		if ( proptype( CYOA_Me.location, CYOA_global.ary[ self.num ] ) = 5 ) {
			"Please enter a valid choice from the menu. ";
			abort;
		}

		newloc := CYOA_Me.location.( CYOA_global.ary[ self.num ] );

		if ( newloc != nil ) {
			CYOA_Me.location := newloc;
			"\b\t";
			CYOA_Me.location.desc;
		}
	}
;

oneVerb: choiceVerb
	verb = 'one'
	num = 1
;

twoVerb: choiceVerb
	verb = 'two'
	num = 2
;

threeVerb: choiceVerb
	verb = 'three'
	num = 3
;

fourVerb: choiceVerb
	verb = 'four'
	num = 4
;

fiveVerb: choiceVerb
	verb = 'five'
	num = 5
;

sixVerb: choiceVerb
	verb = 'six'
	num = 6
;

sevenVerb: choiceVerb
	verb = 'seven'
	num = 7
;

eightVerb: choiceVerb
	verb = 'eight'
	num = 8
;

nineVerb: choiceVerb
	verb = 'nine'
	num = 9
;

/*

//
// Here's where the user can quit.
//
CYOA_quitVerb: object
	verb = 'quit' 'q'
	action( actor ) = {
		local yn;
		"\bDo you really want to quit (YES or NO) > ";
		yn := yorn();
		"\b";
		if ( yn = 1 ) {
			endgame.desc;
			quit();
		} else {
			"Okay. ";
		}
	}
;

//
// Here's where the user can back up one turn
//
undoVerb: object
	verb = 'undo' 'u'
	action( actor ) = {
		if ( undo() && undo() ) {
			"(Undoing one command.)\b\t";
			CYOA_Me.location.desc;
		} else {
			"No more undo information available.\b";
		}
	}
;

//
// This command is a concession to convention.
//
lookVerb: object
	verb = 'l' 'look'
	action( actor ) = {
		"\t";
		CYOA_Me.location.desc;
	}
;

//
// Some very basic help
//
helpVerb: object
	verb = 'help'
	action( actor ) = {
		"This game does not accept standard interactive commands.
		Instead, it presents you with a situation and a number of
		choices to make. You can choose one of the options given,
		or you may enter one of the following:\n
		\thelp\tThis help message.\n
		\tquit\tEnd the game (abbr: 'q').\n
		\tlook\tRe-display the description of the situation (abbr: 'l').\n
		\tundo\tUndo the previous command (abbr: 'u').\n
		\tsave\tSave the current game in progress.\n
		\trestore\tRestore a previously saved game.\n
		\trestart\tRestart the game from the beginning.\n";
	}
;

//
// Save code paraphrased from adv.t
//
CYOA_saveVerb: object
//	verb = 'save'
	action( actor ) = {
		local savefile;

		savefile := askfile( 'File to save game in' );
		if ( savefile = nil or savefile = '' ) {
			"Failed. ";
		} else if ( save( savefile ) ) {
			"Saved failed. ";
		} else {
			"Saved. ";
		}
	}
;


//
// restore code paraphrased from adv.t
//
CYOA_restoreVerb: object
//	verb = 'load' 'restore'
	action( actor ) = {
		local savefile;

		savefile := askfile( 'File to restore game from' );
		if ( savefile = nil or savefile = '' ) {
			"Failed. ";
		} else if ( restore( savefile ) ) {
			"Restore failed. ";
		} else {
			"Restored.\b\t";
			CYOA_Me.location.desc;
		}
	}
;

//
// restart code paraphrased from adv.t
//
CYOA_initRestart: function( param )
{
	CYOA_global.restarting := true;
}

CYOA_restartVerb: object
//	verb = 'restart'
	action( actor ) = {
		local yesno;
		while ( true ) {
			"Are you sure you want to start over? (YES or NO) > ";
			yesno := yorn();
			if ( yesno = 1 ) {
				"\b\b* * * RESTARTING * * *\b\b";
				restart(CYOA_initRestart, CYOA_global.CYOA_initRestartParam);
				break;
			} else if ( yesno = 0 ) {
				"\nOkay.\n";
				break;
			}
		}
	}
;

*/

