/*
 * replacement for ecvt() function because BSDI doesn't have it
 * by Andy Beals, bandy@cinnamon.com [permanent home address]
 * 3/8/94
 *
 */

#include <stdio.h>

char	*
ecvt(value, ndigit, decpt, sign)
double	value;
int	ndigit, *decpt, *sign; {
    static char	output[128];	/* big enough */
    char	*s, *index();

    *sign=0;

    if(value == 0) {
	strcpy(output, "0");
	*decpt=0;
	goto ciao;
    }

    if(value < 0) {
	*sign = -1;
	value *= -1;
    }
    sprintf(output, "%*.*f", ndigit, ndigit, value);

#ifdef	DEBUG
    fprintf(stderr, "ecvt works with %s\n", output);
#endif

    while(output[0] == ' ')
	strcpy(output, output+1);	/* kill leading blank */

    while(output[0] == '0')
	strcpy(output, output+1);	/* kill leading zero */

    s=index(output, '.');

    if(s != NULL) {
#ifdef	DEBUG
	fprintf(stderr, "ecvt deletes ., s=%x, output=%x, s-output=%d\n", s, output, s-output);
#endif
	strcpy(s, s+1);
	*decpt = s-output;
    } else {
	*decpt = strlen(output);
    }


    s=index(output, 'e');
    if(s == NULL) goto ciao;

    *s++ = '\0';

    if(*s == '+') s++;

    *decpt += atoi(s);

ciao:

    while(strlen(output) < ndigit) strcat(output, "0");

#ifdef	DEBUG
    fprintf(stderr, "ecvt returns %s, decpt=%d, sign=%d\n", output, *decpt, *sign);
#endif

    return output;
}
