.TH RPC.ETHERD 8 "5 October 1992"
.SH NAME
rpc.etherd, etherd \- network statistic server
.SH SYNOPSIS
.B rpc.etherd
[
.B -d
]
.I interface
.SH DESCRIPTION
.B rpc.etherd 
is a value added replacement for the SunOS program
.B rpc.etherd
which runs on DEC Ultrix, Linux and BSD-ish systems with Berkeley Packet
Filter.

The
.B \-d
option increases the debugging verbosity level, if the program
was compiled for it.

.I rpc.etherd
gathers statistics about the network as seen from the given
network interface.
.I rpc.etherd
must be run as root, as it places the interface in promiscuous mode.
.I rpc.etherd
requires a front end to display the statistics, such as
.I ethertop(1)
or
.I traffic(1).

The reporting of these statistics is via SUN remote procedure call (RPC).


Although
.I rpc.etherd
is designed to emulate the SunOS
.I rpc.etherd
in every way, the exceptions are:
.RS

Statistics for "other" include both IP and other protocols not categorized
by the ether.x specification.

When the protocol filters are in operation, the "other" field still reports
"other" protocols.  The SunOS version does not.

Regardless of the IP packet type, host statistics are kept for each IP
host.  This means that if a host is sending out large amounts of
IGMP messages, these will register.  The SunOS version may or may not
do this.  It is reasonably difficult to verify at this time.

.RE
This program causes a substancial performance impact because it reads
ALL packets which arrive on the network interface.  A large queue is
allocated both within the kernel and in user space.  A packet filter
could be written to overcome this somewhat, but then the network
statistics would only report what the packet filter let through.

The protocol "filter" procedure call can take any IP packet type as its
argument.  Thus, packets statistics other than the
.I rpc.etherd
was written to provide DEC users with a proper back end for the
.B ethertop
program by the same author.  It was written in a "clean room / black box"
environment, meaning without knowlege of SunOS source code.
As a result, obscure features and bugs may be present in both implementations.

.SH "SEE ALSO"
.I ethertop(1), traffic(1)
.SH DIAGNOSTICS
Error messages are reported via
.I syslog(3).

If compiled for debugging, it will spew to stderr too many information
to be useful.
.SH BUGS
A filter of any kind applied by a client program will affect all clients
making RPC calls.  Any client that calls the etherproc_off procedure
will turn of the interface monitoring, thus rendering other clients
useless.

The ether.x protocol is flawed.  Host addresses are passed as int's
rather than struct in_addr's.  This causes unnecessary byte swapping
of network addresses that are already in network order. This
.I rpc.etherd
compensates for this by byte swapping internally.

This version of
.I rpc.etherd
will report random garbage statistics if invoked on a non-ethernet interface
(e.g. slip or loopback).

The implementation should use
.I libcap(3)
instead of re-inventing the wheel for each platform.

.SH AUTHOR
Originally written for Ultrix by Guy Cardwell, UC Irvine Academic
Computing, gcardwel@uci.edu

Ported to Linux, SunOS and BPF-using systems (notably FreeBSD 2.x)
by Stefan Petri <petri@ibr.cs.tu-bs.de>. The machine-specific device
handling code was taken from the packet capture library
.I libpcap(3).
