/*
 * Copyright (c) 1989 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *	%W% (Berkeley) %G%
 */
#include <sys/types.h>
#include <db.h>

/* Map dbm interface onto hash(3) */
#define DBM_RDONLY	O_RDONLY

/* Flags to dbm_store() */
#define DBM_INSERT      0
#define DBM_REPLACE     1

typedef struct {
	char 	*dptr;
	int	dsize;
} datum;

typedef DB	DBM;

#ifdef __STDC__ || c_plusplus
extern DBM *dbm_open(const char *, int, int);
extern void dbm_close(DBM *);
extern datum dbm_fetch(DBM *, datum);
extern datum dbm_firstkey(DBM *);
extern datum dbm_nextkey(DBM *);
extern long dbm_forder(DBM *, datum);
extern int dbm_delete(DBM *, datum);
extern int dbm_store(DBM *, datum, datum, int);
#else
extern DBM *dbm_open();
extern void dbm_close();
extern datum dbm_fetch();
extern datum dbm_firstkey();
extern datum dbm_nextkey();
extern long dbm_forder();
extern int dbm_delete();
extern int dbm_store();
#endif
