/*
 * This code handles posix-style stuff, for non POSIX.1 systems.
 */

#ifndef O_RDWR
#include <fcntl.h>
#endif

#ifndef O_ACCMODE
#define	O_ACCMODE	(O_RDONLY|O_WRONLY|O_RDWR)
#endif

/*
 * Signal stuff.
 *
 * Assumes that signals.h has already been loaded.
 * 
 * Written by Theodore Ts'o.
 */
#ifndef SIG_BLOCK

typedef unsigned int sigset_t;

#define	sigemptyset(set)	(*(set) = 0)
#define	sigfillset(set)		(*(set) = ~(sigset_t)0, 0)
#define	sigaddset(set,signo)	(*(set) |= sigmask(signo), 0)
#define	sigdelset(set,signo)	(*(set) &= ~sigmask(signo), 0)
#define	sigismember(set,signo)	((*(set) & sigmask(signo)) != 0)

#define	SIG_BLOCK	1
#define	SIG_UNBLOCK	2
#define	SIG_SETMASK	3

static int _sigtemp;		/* For the use of sigprocmask */

/*
 * What a mess; I didn't want to deal with loading in a separate file,
 * and putting a procedure in a .h file is only slightly worse that
 * what follows below....
 */
#define	sigprocmask(how,set,oset) \
	((_sigtemp = (((how) == SIG_BLOCK) ? \
	sigblock(0) | *(set) : (((how) == SIG_UNBLOCK) ? \
	sigblock(0) & ~(*(set)) : ((how) == SIG_SETMASK ? \
	*(set) : sigblock(0))))), ((oset) ? \
	(*(oset) = sigsetmask(_sigtemp)) : sigsetmask(_sigtemp)), 0)
#endif
