/* blkheader.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 *
 * (was called blockheader.h, but this was too long on SysV for RCS)
 */

/* descibe the physical WOrdPlace database...
 *
 * $Id: blkheader.h,v 1.3 92/02/15 06:00:28 lee Exp $
 *
 * $Log:	blkheader.h,v $
 * Revision 1.3  92/02/15  06:00:28  lee
 * Changed Header to Id for revision control.
 * 
 * Revision 1.2  90/03/20  20:57:46  lee
 * removed WID from the block.  This reduces checking, but should also
 * noticeably reduce the size of the database.
 * 
 * Revision 1.1  90/03/20  20:54:44  lee
 * Initial revision
 *
 */

/* The header of each block -- I can't use sReadNumber, because I don't know
 * the size of NextOffset until I get to the end, and it's too late by then!
 *
 * I should really store the block offset, and not the byte offset.  This
 * would save a whole byte -- I could use 3 bytes for the NextBlock!
 */
typedef struct {
    unsigned long NextOffset; /* a byte offset */
#ifdef WIDINBLOCK
    unsigned long WID;
#endif
    char Data[1]; /* the address of this is where the number start... */
} t_BlockHeader;
