/* emalloc.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* emalloc.h -- header file for emalloc.c, Liam Quin's malloc() wrapper
 *
 * $Id: emalloc.h,v 1.5 91/03/02 19:40:04 lee Rel1-10 $
 *
 * $Log:	emalloc.h,v $
 * Revision 1.5  91/03/02  19:40:04  lee
 * Simpler version of malloc defines if MALLOCTRACE unused...
 * 
 * Revision 1.4  91/03/02  18:31:21  lee
 * Simpler call to malloc wrappers if MALLOCTRACE undefined.
 * 
 * Revision 1.3  90/10/06  02:18:26  lee
 * Prepared for first beta release.
 * 
 * Revision 1.2  90/08/29  21:57:44  lee
 * removed most of the testing code
 * 
 * Revision 1.1  90/08/09  19:14:48  lee
 * Initial revision
 * 
 * Revision 2.2  89/10/08  20:45:20  lee
 * Working version of nx-text engine.  Addfile and wordinfo work OK.
 * 
 *
 */

extern int _LiamIsInCurses;

#define InitScr() (_LiamIsInCurses = initscr())
#define EndWin() (_LiamIsInCurses ? (_LiamIsInCurses = 0), endwin() : 0)

extern char *_emalloc(), *_erealloc(), *_ecalloc();
extern void _efree();

#ifdef MALLOCTRACE
#define emalloc(u) _emalloc(u, __FILE__, __LINE__)
#define erealloc(s, u) _erealloc(s, u, __FILE__, __LINE__)
#define ecalloc(n, siz) _ecalloc(n, siz, __FILE__, __LINE__)
#define efree(s) _efree(s, __FILE__, __LINE__)
#else
#define emalloc _emalloc
#define erealloc _erealloc
#define ecalloc _ecalloc
#define efree _efree
#endif
