/* numbers.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

/* ReadNumber and WriteNumber take/return a long, using a compression
 * algorithm to reduce the amount of data taken.
 *
 * They use (char *) pointers instead if prefixes with an s.
 *
 * $Id: numbers.h,v 1.4 92/01/30 23:47:22 lee Exp $
 *
 */

#ifdef HAVE_INLINE

/* See comments in liblqtext/numbers.c */

INLINE void
fWriteNumber(f, Number)
    FILE *f;
    unsigned long Number;
{
    while (Number > 0177) {
	putc((Number & 0177) | 0200, f);
	Number >>= 7;
    }
    putc(Number & 0177, f);
}

#define PutC(ch, S)  (*((*S)++) = (char) (ch))

INLINE void
sWriteNumber(s, Number)
    char **s;
    unsigned long Number;
{
    while (Number > 0177) {
	PutC((Number & 0177) | 0200, s);
	Number >>= 7;
    }
    PutC(Number & 0177, s);
}

INLINE unsigned long
fReadNumber(f)
    FILE *f;
{
    unsigned long Result = 0L;
    int ThereIsMore;
    int Shift = 0;

    do {
	Result |= ((ThereIsMore = getc(f)) & 0177) << Shift;
	if (ThereIsMore == EOF) {
	    return -1;
	}
	ThereIsMore &= 0200;
	Shift += 7;
    } while (ThereIsMore);
    return Result;
}

#define GetC(S) \
    ( (unsigned int) * (unsigned char *) ((* (unsigned char **)S)++) )

INLINE unsigned long
sReadNumber(s)
    char **s;
{
    unsigned long Result = 0L;
    int ThereIsMore;
    int Shift = 0;

    do {
	Result |= ((ThereIsMore = GetC(s)) & 0177) << Shift;
	ThereIsMore &= 0200;
	Shift += 7;
    } while (ThereIsMore);
    return Result;
}

#else /* HAVE_INLINE */

extern unsigned long fReadNumber();
extern unsigned long sReadNumber();

extern void fWriteNumber();
extern void sWriteNumber();

#endif /* HAVE_INLINE */

/*
 * $Log:	numbers.h,v $
 * Revision 1.4  92/01/30  23:47:22  lee
 * Placed inline code in the header file so it can be declared INLINE sensibly.
 * 
 * Revision 1.3  90/10/06  02:18:30  lee
 * Prepared for first beta release.
 * 
 * Revision 1.2  90/08/09  19:15:42  lee
 * after BSD lint and saber-C
 * 
 * Revision 1.1  90/04/19  19:27:04  lee
 * Initial revision
 * 
 * Revision 2.2  89/10/08  20:46:43  lee
 * Working version of nx-text engine.  Addfile and wordinfo work OK.
 * 
 * Revision 1.2  89/09/16  21:15:40  lee
 * First demonstratable version.
 * 
 * Revision 1.1  89/09/07  21:06:02  lee
 * Initial revision
 * 
 */
