/* pblock.h -- Copyright 1989 Liam R. Quin.  All Rights Reserved.
 * This code is NOT in the public domain.
 * See the file COPYRIGHT for full details.
 */

#ifndef PBLOCK_H /* the matching endif is at the end of the file... */

# define PBLOCK_H
/* The physical Word Database...
 *
 * First, there is the WID (from 1 to 4 bytes)
 *
 * Then, there is a NEXT pointer (or 0).
 *
 * Then, there is a list of (FID, OFFSET) pairs.
 *
 * $Id: pblock.h,v 1.4 92/02/15 06:00:05 lee Exp $
 *
 * $Log:	pblock.h,v $
 * Revision 1.4  92/02/15  06:00:05  lee
 * Changed Header to Id for revision control.
 * 
 * Revision 1.3  91/06/16  18:18:12  lee
 * Move WordPlace into a separate header file.
 * 
 * Revision 1.2  90/08/09  19:15:45  lee
 * after BSD lint and saber-C
 * 
 * Revision 1.1  90/03/01  23:54:37  lee
 * Initial revision
 * 
 * Revision 2.2  89/10/08  20:47:04  lee
 * Working version of nx-text engine.  Addfile and wordinfo work OK.
 * 
 * Revision 2.1  89/10/02  01:15:36  lee
 * New index format, with Block/WordInBlock/Flags/BytesSkipped info.
 * 
 * Revision 1.2  89/09/16  21:15:43  lee
 * First demonstratable version.
 * 
 * Revision 1.1  89/09/07  21:06:09  lee
 * Initial revision
 * 
 *
 */

#ifndef WORDPLACE_H
# include "wordplace.h"
#endif

#define SET_BLOCK_AS_FREE 37 /* unlikely numbers to be passed by mistake */
#define SET_BLOCK_AS_USED 119

/* Warning: One cannot use structure copy for a pblock! */

/* This does *NOT* correspond to the physical disk layout -- see pblock.c */
typedef struct {
    t_WID WID; /* for checking; */
    unsigned long ChainStart;
    unsigned long NumberOfWordPlaces;
    t_WordPlace WordPlaces[1]; /* made by joining lots of disk blocks... */
} t_pblock;

#endif
